/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.listener.reforging;

import java.util.ArrayList;
import java.util.List;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.api.event.MMOItemReforgeEvent;
import net.Indyuce.mmoitems.stat.data.StringListData;
import net.Indyuce.mmoitems.stat.type.StatHistory;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public class RFGKeepLore
implements Listener {
    @EventHandler
    public void onReforge(MMOItemReforgeEvent event) {
        if (!event.getOptions().shouldKeepLore()) {
            return;
        }
        StringListData loreData = (StringListData)event.getOldMMOItem().getData(ItemStats.LORE);
        if (loreData == null) {
            return;
        }
        ArrayList<String> extraLore = this.extractLore(loreData.getList(), event.getOptions().getKeepCase());
        if (extraLore.size() == 0) {
            return;
        }
        StatHistory hist = event.getNewMMOItem().computeStatHistory(ItemStats.LORE);
        StringListData original = (StringListData)hist.getOriginalData();
        for (String str : extraLore) {
            original.getList().add(str);
        }
        hist.setOriginalData(original);
    }

    @NotNull
    ArrayList<String> extractLore(@NotNull List<String> lore, @NotNull String keepCase) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String str : lore) {
            if (!str.startsWith(keepCase)) continue;
            ret.add(str);
        }
        return ret;
    }
}

