/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.listener.reforging;

import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ReforgeOptions;
import net.Indyuce.mmoitems.api.event.MMOItemReforgeEvent;
import net.Indyuce.mmoitems.api.item.mmoitem.LiveMMOItem;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.api.util.MMOItemReforger;
import net.Indyuce.mmoitems.stat.data.EnchantListData;
import net.Indyuce.mmoitems.stat.data.GemSocketsData;
import net.Indyuce.mmoitems.stat.data.GemstoneData;
import net.Indyuce.mmoitems.stat.data.type.Mergeable;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.GemStoneStat;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.stat.type.StatHistory;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class RFGKeepGems
implements Listener {
    @EventHandler
    public void onReforge(MMOItemReforgeEvent event) {
        if (!event.getOptions().shouldKeepGemStones()) {
            return;
        }
        GemSocketsData oldGemstoneData = (GemSocketsData)event.getOldMMOItem().getData(ItemStats.GEM_SOCKETS);
        if (oldGemstoneData == null) {
            return;
        }
        GemSocketsData newGemstoneData = (GemSocketsData)event.getNewMMOItem().getData(ItemStats.GEM_SOCKETS);
        ArrayList<GemstoneData> lostGems = new ArrayList<GemstoneData>();
        if (newGemstoneData != null) {
            ArrayList<GemstoneData> transferredGems = new ArrayList<GemstoneData>();
            ArrayList<String> arrayList = new ArrayList<String>(newGemstoneData.getEmptySlots());
            ArrayList<GemstoneData> oldSockets = new ArrayList<GemstoneData>(oldGemstoneData.getGemstones());
            for (GemstoneData gemstoneData : oldSockets) {
                if (arrayList.size() == 0) {
                    lostGems.add(gemstoneData);
                    continue;
                }
                String colour = gemstoneData.getSocketColor();
                if (colour == null) {
                    colour = GemSocketsData.getUncoloredGemSlot();
                }
                String newColorToInsertInto = null;
                for (String slot : arrayList) {
                    if (!slot.equals(GemSocketsData.getUncoloredGemSlot()) && !colour.equals(slot)) continue;
                    newColorToInsertInto = slot;
                }
                if (newColorToInsertInto != null) {
                    MMOItem restoredGem = event.getOldMMOItem().extractGemstone(gemstoneData);
                    if (restoredGem == null) {
                        lostGems.add(gemstoneData);
                        continue;
                    }
                    MMOItemReforger gemReforge = new MMOItemReforger(restoredGem.newBuilder().build());
                    if (!gemReforge.canReforge()) {
                        lostGems.add(gemstoneData);
                        continue;
                    }
                    gemReforge.setPlayer(event.getPlayer());
                    if (!gemReforge.reforge(MMOItems.plugin.getLanguage().gemRevisionOptions)) {
                        lostGems.add(gemstoneData);
                        continue;
                    }
                    event.getReforger().getReforgingOutput().addAll(gemReforge.getReforgingOutput());
                    LiveMMOItem gemResult = new LiveMMOItem(gemReforge.getResult());
                    GemstoneData reforgedGemData = new GemstoneData(gemResult, newColorToInsertInto, gemstoneData.getHistoricUUID());
                    reforgedGemData.setLevel(gemstoneData.getLevel());
                    arrayList.remove(newColorToInsertInto);
                    transferredGems.add(reforgedGemData);
                    for (ItemStat stat : gemResult.getStats()) {
                        StatData data;
                        if (stat instanceof GemStoneStat || !((data = gemResult.getData(stat)) instanceof Mergeable) || data instanceof EnchantListData && data.isEmpty()) continue;
                        StatHistory hist = event.getNewMMOItem().computeStatHistory(stat);
                        hist.registerGemstoneData(reforgedGemData.getHistoricUUID(), data);
                    }
                    continue;
                }
                lostGems.add(gemstoneData);
            }
            GemSocketsData reforgedGemstoneData = new GemSocketsData(arrayList);
            for (GemstoneData gem : transferredGems) {
                if (gem == null) continue;
                reforgedGemstoneData.add(gem);
            }
            StatHistory statHistory = event.getNewMMOItem().computeStatHistory(ItemStats.GEM_SOCKETS);
            statHistory.setOriginalData(reforgedGemstoneData);
            event.getNewMMOItem().setData(ItemStats.GEM_SOCKETS, statHistory.recalculate(event.getNewMMOItem().getUpgradeLevel()));
        } else {
            lostGems.addAll(oldGemstoneData.getGemstones());
        }
        if (ReforgeOptions.dropRestoredGems) {
            for (GemstoneData gemstoneData : lostGems) {
                MMOItem restoredGem = event.getOldMMOItem().extractGemstone(gemstoneData);
                if (restoredGem == null) {
                    MMOItems.print(null, "$bGemstone $r{0} {1} $bno longer exists, it was$f deleted$b from $u{2}$b's {3}$b. ", "RevID", gemstoneData.getMMOItemType(), gemstoneData.getMMOItemID(), event.getPlayer() == null ? "null" : event.getPlayer().getName(), SilentNumbers.getItemName((ItemStack)event.getReforger().getStack(), (boolean)false));
                    continue;
                }
                MMOItemReforger gemReforge = new MMOItemReforger(restoredGem.newBuilder().build());
                if (gemReforge.canReforge()) {
                    gemReforge.setPlayer(event.getPlayer());
                    gemReforge.reforge(MMOItems.plugin.getLanguage().gemRevisionOptions);
                    event.getReforger().getReforgingOutput().addAll(gemReforge.getReforgingOutput());
                    event.getReforger().addReforgingOutput(gemReforge.getResult());
                    continue;
                }
                event.getReforger().addReforgingOutput(restoredGem.newBuilder().build());
            }
        }
    }
}

