/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.listener.reforging;

import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.event.MMOItemReforgeEvent;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.stat.Enchants;
import net.Indyuce.mmoitems.stat.data.EnchantListData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.StatHistory;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public class RFGKeepEnchantments
implements Listener {
    @EventHandler
    public void onReforge(MMOItemReforgeEvent event) {
        if (!event.getOptions().shouldKeepEnchantments()) {
            return;
        }
        MMOItem operable = event.getOldMMOItem().clone();
        if (!operable.hasData(ItemStats.ENCHANTS)) {
            operable.setData(ItemStats.ENCHANTS, new EnchantListData());
        }
        Enchants.separateEnchantments(operable);
        StatHistory hist = operable.computeStatHistory(ItemStats.ENCHANTS);
        EnchantListData maybeOriginalEnchs = ((EnchantListData)hist.getOriginalData()).clone();
        StatHistory future = event.getNewMMOItem().computeStatHistory(ItemStats.ENCHANTS);
        for (StatData pEnchants : hist.getExternalData()) {
            future.registerExternalData(pEnchants);
        }
        maybeOriginalEnchs.identifyTrueOriginalEnchantments(event.getNewMMOItem());
    }

    void log(@NotNull EnchantListData enchList, @NotNull String title) {
        MMOItems.print(null, "  \u00a73> \u00a77" + title + ":", null, new String[0]);
        for (Enchantment e : enchList.getEnchants()) {
            MMOItems.print(null, "  \u00a7b * \u00a77" + e.getName() + " \u00a7f" + enchList.getLevel(e), null, new String[0]);
        }
    }
}

