/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.listener.option;

import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.version.VInventoryView;
import io.lumine.mythic.lib.version.VersionUtils;
import java.util.Map;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoulboundNoDrop
implements Listener {
    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void cannotDrop(PlayerDropItemEvent event) {
        if (this.isBound(event.getItemDrop().getItemStack(), (HumanEntity)event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void cannotDragAround(InventoryDragEvent event) {
        VInventoryView view = VersionUtils.getView((InventoryEvent)event);
        if (view.getType() == InventoryType.CRAFTING) {
            return;
        }
        int topInventorySize = view.getTopInventory().getContents().length;
        for (Map.Entry entry : event.getNewItems().entrySet()) {
            if ((Integer)entry.getKey() >= topInventorySize || !this.isBound((ItemStack)entry.getValue(), event.getWhoClicked())) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void cannotMoveAround(InventoryClickEvent event) {
        block4: {
            if (VersionUtils.getView((InventoryEvent)event).getType() == InventoryType.CRAFTING) {
                return;
            }
            try {
                boolean result = this.isSafe(event);
                if (!result) {
                    event.setCancelled(true);
                }
            }
            catch (RuntimeException exception) {
                if (!this.isBound(event.getCurrentItem(), event.getWhoClicked()) && !this.isBound(event.getCursor(), event.getWhoClicked())) break block4;
                event.setCancelled(true);
            }
        }
    }

    private boolean isSafe(@NotNull InventoryClickEvent event) {
        switch (event.getAction()) {
            case NOTHING: 
            case PICKUP_ALL: 
            case PICKUP_SOME: 
            case PICKUP_HALF: 
            case PICKUP_ONE: 
            case COLLECT_TO_CURSOR: 
            case CLONE_STACK: 
            case HOTBAR_MOVE_AND_READD: {
                return true;
            }
            case DROP_ONE_CURSOR: 
            case DROP_ALL_CURSOR: {
                return !this.isBound(event.getCursor(), event.getWhoClicked());
            }
            case DROP_ALL_SLOT: 
            case DROP_ONE_SLOT: {
                return !this.isBound(event.getCurrentItem(), event.getWhoClicked());
            }
            case SWAP_WITH_CURSOR: 
            case PLACE_ALL: 
            case PLACE_SOME: 
            case PLACE_ONE: {
                if (event.getClickedInventory().getType() == InventoryType.PLAYER) {
                    return true;
                }
                return !this.isBound(event.getCursor(), event.getWhoClicked());
            }
            case HOTBAR_SWAP: {
                if (event.getClickedInventory().getType() == InventoryType.PLAYER) {
                    return true;
                }
                ItemStack hotbarItem = event.getWhoClicked().getInventory().getItem(event.getHotbarButton());
                return !this.isBound(hotbarItem, event.getWhoClicked());
            }
            case MOVE_TO_OTHER_INVENTORY: {
                if (event.getClickedInventory().getType() != InventoryType.PLAYER) {
                    return true;
                }
                return !this.isBound(event.getCurrentItem(), event.getWhoClicked());
            }
        }
        throw new RuntimeException("Not implemented");
    }

    private boolean isBound(@Nullable ItemStack item, @NotNull HumanEntity player) {
        return item != null && item.hasItemMeta() && MMOUtils.isSoulboundTo(NBTItem.get((ItemStack)item), (Player)player);
    }
}

