/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.listener;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.event.PlayerAttackEvent;
import io.lumine.mythic.lib.api.event.SynchronizedDataLoadEvent;
import io.lumine.mythic.lib.api.event.armorequip.ArmorEquipEvent;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.damage.ProjectileAttackMetadata;
import io.lumine.mythic.lib.entity.ProjectileMetadata;
import io.lumine.mythic.lib.entity.ProjectileType;
import java.util.Iterator;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.DeathItemsHandler;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.interaction.projectile.ArrowPotionEffectArrayItem;
import net.Indyuce.mmoitems.api.interaction.util.InteractItem;
import net.Indyuce.mmoitems.api.interaction.weapon.Weapon;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.util.DeathDowngrading;
import net.Indyuce.mmoitems.stat.data.PotionEffectData;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerListener
implements Listener {
    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onDeathForUpgradeLoss(@NotNull PlayerDeathEvent event) {
        if (!PlayerData.has(event.getEntity())) {
            return;
        }
        new DelayedDeathDowngrade(event).runTaskLater((Plugin)MMOItems.plugin, 3L);
    }

    @EventHandler
    public void fullSync(SynchronizedDataLoadEvent event) {
        if (event.syncIsFull()) {
            PlayerData playerData = PlayerData.get(event.getHolder().getUniqueId());
            playerData.updateInventory();
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void keepItemsOnDeath(PlayerDeathEvent event) {
        if (event.getKeepInventory()) {
            return;
        }
        Player player = event.getEntity();
        DeathItemsHandler soulboundInfo = new DeathItemsHandler(player);
        Iterator iterator = event.getDrops().iterator();
        while (iterator.hasNext()) {
            ItemStack item = (ItemStack)iterator.next();
            NBTItem nbt = NBTItem.get((ItemStack)item);
            if (!nbt.getBoolean("MMOITEMS_DISABLE_DEATH_DROP") && (!MMOItems.plugin.getLanguage().keepSoulboundOnDeath || !MMOUtils.isSoulboundTo(nbt, player))) continue;
            iterator.remove();
            soulboundInfo.registerItem(item);
        }
        soulboundInfo.registerIfNecessary();
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        DeathItemsHandler.readAndRemove(event.getPlayer());
    }

    @EventHandler
    public void onArmorEquip(ArmorEquipEvent event) {
        if (event.getNewArmorPiece() == null) {
            return;
        }
        if (!PlayerData.get((OfflinePlayer)event.getPlayer()).getRPG().canUse(NBTItem.get((ItemStack)event.getNewArmorPiece()), true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void registerTridents(ProjectileLaunchEvent event) {
        if (!(event.getEntity() instanceof Trident) || !(event.getEntity().getShooter() instanceof Player)) {
            return;
        }
        InteractItem item = new InteractItem((Player)event.getEntity().getShooter(), Material.TRIDENT);
        if (!item.hasItem()) {
            return;
        }
        NBTItem nbtItem = MythicLib.plugin.getVersion().getWrapper().getNBTItem(item.getItem());
        Type type = Type.get(nbtItem.getType());
        PlayerData playerData = PlayerData.get((OfflinePlayer)((Player)event.getEntity().getShooter()));
        if (type != null) {
            Weapon weapon = new Weapon(playerData, nbtItem);
            if (!weapon.checkItemRequirements() || !weapon.checkAndApplyWeaponCosts()) {
                event.setCancelled(true);
                return;
            }
            ProjectileMetadata proj = ProjectileMetadata.create((MMOPlayerData)playerData.getMMOPlayerData(), (EquipmentSlot)EquipmentSlot.fromBukkit((org.bukkit.inventory.EquipmentSlot)item.getSlot()), (ProjectileType)ProjectileType.TRIDENT, (Entity)event.getEntity());
            proj.setSourceItem(nbtItem);
            proj.setCustomDamage(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void registerArrowSpecialEffects(PlayerAttackEvent event) {
        if (!(event.getAttack() instanceof ProjectileAttackMetadata)) {
            return;
        }
        ProjectileAttackMetadata projAttack = (ProjectileAttackMetadata)event.getAttack();
        @Nullable ProjectileMetadata data = ProjectileMetadata.get((Entity)projAttack.getProjectile());
        if (data == null || data.getSourceItem() == null) {
            return;
        }
        this.applyPotionEffects(data, event.getEntity());
    }

    private void applyPotionEffects(ProjectileMetadata proj, LivingEntity target) {
        if (proj.getSourceItem().hasTag("MMOITEMS_ARROW_POTION_EFFECTS")) {
            for (ArrowPotionEffectArrayItem entry : (ArrowPotionEffectArrayItem[])MythicLib.plugin.getJson().parse(proj.getSourceItem().getString("MMOITEMS_ARROW_POTION_EFFECTS"), ArrowPotionEffectArrayItem[].class)) {
                target.addPotionEffect(new PotionEffectData(PotionEffectType.getByName((String)entry.type), entry.duration, entry.level).toEffect());
            }
        }
    }

    @Deprecated
    @EventHandler
    public void registerInventoryUpdates1(PlayerSwapHandItemsEvent event) {
        PlayerData.get((OfflinePlayer)event.getPlayer()).getInventory().scheduleUpdate();
    }

    @Deprecated
    @EventHandler
    public void registerInventoryUpdates2(PlayerItemHeldEvent event) {
        PlayerData.get((OfflinePlayer)event.getPlayer()).getInventory().scheduleUpdate();
    }

    @Deprecated
    @EventHandler
    public void registerInventoryUpdates3(PlayerDropItemEvent event) {
        PlayerData.get((OfflinePlayer)event.getPlayer()).getInventory().scheduleUpdate();
    }

    private static class DelayedDeathDowngrade
    extends BukkitRunnable {
        @NotNull
        final PlayerDeathEvent event;

        DelayedDeathDowngrade(@NotNull PlayerDeathEvent event) {
            this.event = event;
        }

        public void run() {
            DeathDowngrading.playerDeathDowngrade(this.event.getEntity());
        }
    }
}

