/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.listener;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import io.lumine.mythic.lib.version.VInventoryView;
import io.lumine.mythic.lib.version.VersionUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.interaction.util.DurabilityItem;
import net.Indyuce.mmoitems.api.util.MMOItemReforger;
import net.Indyuce.mmoitems.listener.reforging.RFFKeepAmount;
import net.Indyuce.mmoitems.listener.reforging.RFFKeepSkins;
import net.Indyuce.mmoitems.listener.reforging.RFGKeepDurability;
import net.Indyuce.mmoitems.listener.reforging.RFGKeepEnchantments;
import net.Indyuce.mmoitems.listener.reforging.RFGKeepExternalSH;
import net.Indyuce.mmoitems.listener.reforging.RFGKeepGems;
import net.Indyuce.mmoitems.listener.reforging.RFGKeepLore;
import net.Indyuce.mmoitems.listener.reforging.RFGKeepModifications;
import net.Indyuce.mmoitems.listener.reforging.RFGKeepName;
import net.Indyuce.mmoitems.listener.reforging.RFGKeepRNG;
import net.Indyuce.mmoitems.listener.reforging.RFGKeepSoulbound;
import net.Indyuce.mmoitems.listener.reforging.RFGKeepUpgrades;
import net.Indyuce.mmoitems.reforge.ReforgeReason;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemListener
implements Listener {
    public ItemListener() {
        Bukkit.getPluginManager().registerEvents((Listener)new RFGKeepName(), (Plugin)MMOItems.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new RFGKeepLore(), (Plugin)MMOItems.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new RFGKeepEnchantments(), (Plugin)MMOItems.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new RFGKeepExternalSH(), (Plugin)MMOItems.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new RFGKeepGems(), (Plugin)MMOItems.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new RFGKeepModifications(), (Plugin)MMOItems.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new RFGKeepSoulbound(), (Plugin)MMOItems.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new RFGKeepUpgrades(), (Plugin)MMOItems.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new RFGKeepRNG(), (Plugin)MMOItems.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new RFGKeepDurability(), (Plugin)MMOItems.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new RFFKeepAmount(), (Plugin)MMOItems.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new RFFKeepSkins(), (Plugin)MMOItems.plugin);
    }

    @EventHandler
    private void onItemCraftRepair(PrepareItemCraftEvent event) {
        VInventoryView view = VersionUtils.getView((InventoryEvent)event);
        if (!(view.getPlayer() instanceof Player) || !event.isRepair()) {
            return;
        }
        Player player = (Player)view.getPlayer();
        CraftingInventory inv = event.getInventory();
        ItemStack air = new ItemStack(Material.AIR);
        ItemStack originalResult = inv.getResult();
        inv.setResult(air);
        Bukkit.getScheduler().runTaskLater((Plugin)MMOItems.plugin, () -> {
            List items = Arrays.stream(inv.getMatrix()).filter(Objects::nonNull).filter(itemStack -> !itemStack.getType().isAir()).collect(Collectors.toList());
            long mmoItemsCount = items.stream().filter(itemStack -> NBTItem.get((ItemStack)itemStack).hasTag("MMOITEMS_ITEM_ID")).count();
            if (mmoItemsCount == 0L) {
                inv.setResult(originalResult);
                player.updateInventory();
                return;
            }
            if (mmoItemsCount == 1L || !NBTItem.get((ItemStack)((ItemStack)items.get(0))).getString("MMOITEMS_ITEM_ID").equals(NBTItem.get((ItemStack)((ItemStack)items.get(1))).getString("MMOITEMS_ITEM_ID"))) {
                inv.setResult(air);
                player.updateInventory();
                return;
            }
            inv.setResult(originalResult);
            boolean repairDisabled = items.stream().allMatch(itemStack -> {
                NBTItem nbtItem = NBTItem.get((ItemStack)itemStack);
                return nbtItem.hasTag("MMOITEMS_DISABLE_REPAIRING") && nbtItem.getBoolean("MMOITEMS_DISABLE_REPAIRING");
            });
            boolean hasCustomDurability = items.stream().allMatch(itemStack -> new DurabilityItem(player, (ItemStack)itemStack).isValid());
            if (repairDisabled) {
                inv.setResult(air);
            } else if (hasCustomDurability) {
                DurabilityItem durabilityItem = new DurabilityItem(player, (ItemStack)items.get(0));
                int summedDurability = items.stream().map(itemStack -> new DurabilityItem(player, (ItemStack)itemStack)).map(DurabilityItem::getDurability).reduce(0, Integer::sum);
                int finalDurability = durabilityItem.getMaxDurability() - Math.min(durabilityItem.getMaxDurability(), summedDurability);
                if (finalDurability > 0) {
                    durabilityItem.addDurability(finalDurability);
                }
                inv.setResult(durabilityItem.toItem());
            }
            player.updateInventory();
        }, 1L);
    }

    @EventHandler(ignoreCancelled=true)
    private void itemPickup(EntityPickupItemEvent event) {
        if (!event.getEntity().getType().equals((Object)EntityType.PLAYER)) {
            return;
        }
        ItemStack newItem = ItemListener.modifyItem(event.getItem().getItemStack(), (Player)event.getEntity(), ReforgeReason.PICKUP);
        if (newItem != null) {
            event.getItem().setItemStack(newItem);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void itemCraft(CraftItemEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        ItemStack newItem = ItemListener.modifyItem(event.getCurrentItem(), (Player)event.getWhoClicked(), ReforgeReason.CRAFT);
        if (newItem != null) {
            event.setCurrentItem(newItem);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void inventoryMove(InventoryClickEvent event) {
        if (event.getInventory().getType() != InventoryType.CRAFTING || !(event.getWhoClicked() instanceof Player)) {
            return;
        }
        ItemStack newItem = ItemListener.modifyItem(event.getCurrentItem(), (Player)event.getWhoClicked(), ReforgeReason.CLICK);
        if (newItem != null) {
            event.setCurrentItem(newItem);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void playerJoin(PlayerJoinEvent event) {
        if (!MythicLib.plugin.hasProfiles()) {
            ItemListener.updateInventory(event.getPlayer());
        }
    }

    public static void updateInventory(Player player) {
        ItemStack newItem = ItemListener.modifyItem(player.getEquipment().getHelmet(), player, ReforgeReason.JOIN);
        if (newItem != null) {
            player.getEquipment().setHelmet(newItem);
        }
        if ((newItem = ItemListener.modifyItem(player.getEquipment().getChestplate(), player, ReforgeReason.JOIN)) != null) {
            player.getEquipment().setChestplate(newItem);
        }
        if ((newItem = ItemListener.modifyItem(player.getEquipment().getLeggings(), player, ReforgeReason.JOIN)) != null) {
            player.getEquipment().setLeggings(newItem);
        }
        if ((newItem = ItemListener.modifyItem(player.getEquipment().getBoots(), player, ReforgeReason.JOIN)) != null) {
            player.getEquipment().setBoots(newItem);
        }
        for (int j = 0; j < 9; ++j) {
            newItem = ItemListener.modifyItem(player.getInventory().getItem(j), player, ReforgeReason.JOIN);
            if (newItem == null) continue;
            player.getInventory().setItem(j, newItem);
        }
        newItem = ItemListener.modifyItem(player.getEquipment().getItemInOffHand(), player, ReforgeReason.JOIN);
        if (newItem != null) {
            player.getEquipment().setItemInOffHand(newItem);
        }
    }

    @Nullable
    private static ItemStack modifyItem(@Nullable ItemStack stack, @NotNull Player player, @NotNull ReforgeReason reason) {
        int mmoitemRevision;
        if (stack == null || !stack.hasItemMeta()) {
            return null;
        }
        MMOItemReforger mod = new MMOItemReforger(stack);
        if (!mod.hasTemplate()) {
            return null;
        }
        if ("VANILLA".equals(mod.getNBTItem().getString("MMOITEMS_ITEM_ID"))) {
            return null;
        }
        if (MMOItems.plugin.getConfig().getBoolean("item-revision.disable-on." + reason.name().toLowerCase())) {
            return null;
        }
        int templateRevision = mod.getTemplate().getRevisionId();
        int n = mmoitemRevision = mod.getNBTItem().hasTag(ItemStats.REVISION_ID.getNBTPath()) ? mod.getNBTItem().getInteger(ItemStats.REVISION_ID.getNBTPath()) : 1;
        if (templateRevision <= mmoitemRevision) {
            return null;
        }
        if (!mod.reforge(MMOItems.plugin.getLanguage().revisionOptions, player)) {
            return null;
        }
        for (ItemStack drop : player.getInventory().addItem(mod.getReforgingOutput().toArray(new ItemStack[0])).values()) {
            if (SilentNumbers.isAir((ItemStack)drop)) continue;
            player.getWorld().dropItem(player.getLocation(), drop);
        }
        return mod.getResult();
    }
}

