/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.listener;

import io.lumine.mythic.lib.version.Sounds;
import java.util.Arrays;
import java.util.List;
import net.Indyuce.mmoitems.api.interaction.util.DurabilityItem;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.player.PlayerItemMendEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class DurabilityListener
implements Listener {
    private static final List<EntityDamageEvent.DamageCause> IGNORED_CAUSES = Arrays.asList(EntityDamageEvent.DamageCause.DROWNING, EntityDamageEvent.DamageCause.SUICIDE, EntityDamageEvent.DamageCause.FALL, EntityDamageEvent.DamageCause.VOID, EntityDamageEvent.DamageCause.FIRE_TICK, EntityDamageEvent.DamageCause.SUFFOCATION, EntityDamageEvent.DamageCause.POISON, EntityDamageEvent.DamageCause.WITHER, EntityDamageEvent.DamageCause.STARVATION, EntityDamageEvent.DamageCause.MAGIC);
    private static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    @EventHandler(ignoreCancelled=true)
    public void itemDamage(PlayerItemDamageEvent event) {
        DurabilityItem item = new DurabilityItem(event.getPlayer(), event.getItem());
        if (!item.isValid()) {
            return;
        }
        item.decreaseDurability(event.getDamage());
        ItemStack newVersion = item.toItem();
        if (newVersion == null) {
            event.setDamage(999);
            return;
        }
        event.setCancelled(true);
        event.getItem().setItemMeta(newVersion.getItemMeta());
    }

    @EventHandler(ignoreCancelled=true)
    public void playerDamage(EntityDamageEvent event) {
        if (event.getEntityType() != EntityType.PLAYER || IGNORED_CAUSES.contains(event.getCause())) {
            return;
        }
        Player player = (Player)event.getEntity();
        int damage = Math.max((int)event.getDamage() / 4, 1);
        for (EquipmentSlot slot : ARMOR_SLOTS) {
            if (!this.hasItem(player, slot)) continue;
            this.handleUndamageableItem(player.getInventory().getItem(slot), player, slot, damage);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void playerMeleeAttack(EntityDamageByEntityEvent event) {
        if (event.getDamage() == 0.0 || event.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK || !(event.getEntity() instanceof LivingEntity) || !(event.getDamager() instanceof Player) || event.getEntity().hasMetadata("NPC") || event.getDamager().hasMetadata("NPC")) {
            return;
        }
        Player player = (Player)event.getDamager();
        ItemStack item = player.getInventory().getItemInMainHand();
        this.handleUndamageableItem(item, player, EquipmentSlot.HAND, 1);
    }

    @EventHandler(ignoreCancelled=true)
    public void playerBowAttack(EntityShootBowEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        ItemStack item = event.getBow();
        this.handleUndamageableItem(item, player, EquipmentSlot.HAND, 1);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void mendEvent(PlayerItemMendEvent event) {
        if (event.getRepairAmount() <= 0) {
            return;
        }
        DurabilityItem durItem = new DurabilityItem(event.getPlayer(), event.getItem());
        if (durItem.isValid()) {
            event.getItem().setItemMeta(durItem.addDurability(event.getRepairAmount()).toItem().getItemMeta());
            event.setCancelled(true);
        }
    }

    private void handleUndamageableItem(ItemStack stack, Player player, EquipmentSlot slot, int damage) {
        if (stack.getType().getMaxDurability() != 0) {
            return;
        }
        DurabilityItem item = new DurabilityItem(player, stack);
        if (!item.isValid()) {
            return;
        }
        item.decreaseDurability(damage);
        ItemStack newVersion = item.toItem();
        if (newVersion == null) {
            player.getInventory().setItem(slot, null);
            player.getWorld().playSound(player.getLocation(), Sounds.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            return;
        }
        player.getInventory().getItem(slot).setItemMeta(newVersion.getItemMeta());
    }

    private boolean hasItem(Player player, EquipmentSlot slot) {
        return player.getInventory().getItem(slot) != null && player.getInventory().getItem(slot).getType() != Material.AIR;
    }
}

