/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui.edition.recipe.registry;

import io.lumine.mythic.lib.api.crafting.ingredients.MythicRecipeIngredient;
import io.lumine.mythic.lib.api.crafting.outputs.MythicRecipeOutput;
import io.lumine.mythic.lib.api.crafting.recipes.MythicRecipe;
import io.lumine.mythic.lib.api.crafting.recipes.MythicRecipeBlueprint;
import io.lumine.mythic.lib.api.crafting.recipes.MythicRecipeStation;
import io.lumine.mythic.lib.api.crafting.recipes.ShapedRecipe;
import io.lumine.mythic.lib.api.crafting.recipes.ShapelessRecipe;
import io.lumine.mythic.lib.api.crafting.uimanager.ProvidedUIFilter;
import io.lumine.mythic.lib.api.util.Ref;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackPalette;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import net.Indyuce.mmoitems.api.crafting.recipe.CustomSmithingRecipe;
import net.Indyuce.mmoitems.api.crafting.recipe.SmithingCombinationType;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.gui.edition.recipe.gui.RMG_Smithing;
import net.Indyuce.mmoitems.gui.edition.recipe.gui.RecipeEditorGUI;
import net.Indyuce.mmoitems.gui.edition.recipe.interpreter.RMGRI_Smithing;
import net.Indyuce.mmoitems.gui.edition.recipe.registry.RecipeRegistry;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RMGRR_Smithing
implements RecipeRegistry {
    @NotNull
    final ItemStack displayListItem = RecipeEditorGUI.rename(new ItemStack(Material.SMITHING_TABLE), FFPMMOItems.get().getExampleFormat() + "Smithing Recipe");

    @Override
    @NotNull
    public String getRecipeTypeName() {
        return "Smithing";
    }

    @Override
    @NotNull
    public String getRecipeConfigPath() {
        return "smithing";
    }

    @Override
    @NotNull
    public ItemStack getDisplayListItem() {
        return this.displayListItem;
    }

    @Override
    public void openForPlayer(@NotNull EditionInventory inv, @NotNull String recipeName, Object ... otherParams) {
        new RMG_Smithing(inv.getPlayer(), inv.getEdited(), recipeName, this).open(inv);
    }

    @Override
    @NotNull
    public MythicRecipeBlueprint sendToMythicLib(@NotNull MMOItemTemplate template, @NotNull ConfigurationSection recipeTypeSection, @NotNull String recipeName, @NotNull Ref<NamespacedKey> namespace, @NotNull FriendlyFeedbackProvider ffp) throws IllegalArgumentException {
        RecipeEditorGUI.moveInput(recipeTypeSection, recipeName);
        ConfigurationSection recipeSection = RecipeEditorGUI.getSection(recipeTypeSection, recipeName);
        NamespacedKey nk = (NamespacedKey)namespace.getValue();
        if (nk == null) {
            throw new IllegalArgumentException(FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Illegal (Null) Namespace", (String[])new String[0]));
        }
        String input = RMGRI_Smithing.updateIngredients(recipeSection.getString("input"));
        String[] inputSplit = input.split("\\|");
        ProvidedUIFilter itemPoof = RecipeEditorGUI.readIngredientFrom(inputSplit[0], ffp);
        ProvidedUIFilter ingotPoof = RecipeEditorGUI.readIngredientFrom(inputSplit[1], ffp);
        if (itemPoof.isAir() || ingotPoof.isAir()) {
            throw new IllegalArgumentException(FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Smithing recipe containing AIR, $fignored$b.", (String[])new String[0]));
        }
        MythicRecipeIngredient itemIngredient = new MythicRecipeIngredient(itemPoof);
        MythicRecipeIngredient ingotIngredient = new MythicRecipeIngredient(ingotPoof);
        ShapelessRecipe inputItem = new ShapelessRecipe(nk.getKey(), new MythicRecipeIngredient[]{itemIngredient});
        ShapelessRecipe inputIngot = new ShapelessRecipe(nk.getKey(), new MythicRecipeIngredient[]{ingotIngredient});
        String output = RMGRI_Smithing.updateIngredients(recipeSection.getString("output"));
        String[] outputSplit = output.split("\\|");
        ProvidedUIFilter itemOPoof = RecipeEditorGUI.readIngredientFrom(outputSplit[0], ffp);
        ProvidedUIFilter ingotOPoof = RecipeEditorGUI.readIngredientFrom(outputSplit[1], ffp);
        ShapedRecipe outputItem = itemOPoof.isAir() ? null : ShapedRecipe.single((String)nk.getKey(), (ProvidedUIFilter[])new ProvidedUIFilter[]{itemOPoof});
        ShapedRecipe outputIngot = ingotOPoof.isAir() ? null : ShapedRecipe.single((String)nk.getKey(), (ProvidedUIFilter[])new ProvidedUIFilter[]{ingotOPoof});
        int outputAmount = recipeSection.getInt("amount", 1);
        boolean dropGems = recipeSection.getBoolean("drop-gems", false);
        SmithingCombinationType enchantEffect = this.readSCT(recipeSection.getString("enchantments"));
        SmithingCombinationType upgradeEffect = this.readSCT(recipeSection.getString("upgrades"));
        CustomSmithingRecipe outputRecipe = new CustomSmithingRecipe(template, dropGems, enchantEffect, upgradeEffect, outputAmount);
        outputRecipe.setMainInputConsumption((MythicRecipe)outputItem);
        outputRecipe.setIngotInputConsumption((MythicRecipe)outputIngot);
        MythicRecipeBlueprint ret = new MythicRecipeBlueprint((MythicRecipe)inputItem, (MythicRecipeOutput)outputRecipe, nk);
        ret.addSideCheck("ingot", (MythicRecipe)inputIngot);
        ret.deploy(MythicRecipeStation.SMITHING, namespace);
        return ret;
    }

    @NotNull
    SmithingCombinationType readSCT(@Nullable String str) {
        if (str == null) {
            return SmithingCombinationType.MAXIMUM;
        }
        try {
            return SmithingCombinationType.valueOf(str);
        }
        catch (IllegalArgumentException ignored) {
            return SmithingCombinationType.MAXIMUM;
        }
    }
}

