/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui.edition.recipe.interpreter;

import io.lumine.mythic.lib.api.crafting.uimanager.ProvidedUIFilter;
import net.Indyuce.mmoitems.gui.edition.recipe.gui.RecipeEditorGUI;
import net.Indyuce.mmoitems.gui.edition.recipe.interpreter.RMG_RecipeInterpreter;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RMGRI_Smithing
implements RMG_RecipeInterpreter {
    @NotNull
    ProvidedUIFilter inputItem;
    @NotNull
    ProvidedUIFilter outputItem;
    @NotNull
    ProvidedUIFilter inputIngot;
    @NotNull
    ProvidedUIFilter outputIngot;
    @NotNull
    final ConfigurationSection section;
    public static final String emptyIngredients = "v AIR -|v AIR -";

    @NotNull
    String toYML(@NotNull ProvidedUIFilter item, @NotNull ProvidedUIFilter ingot) {
        return item + "|" + ingot;
    }

    @NotNull
    public ProvidedUIFilter getInputItem() {
        return this.inputItem;
    }

    public void setInputItem(@NotNull ProvidedUIFilter inputItem) {
        this.inputItem = inputItem;
    }

    @NotNull
    public ProvidedUIFilter getOutputItem() {
        return this.outputItem;
    }

    public void setOutputItem(@NotNull ProvidedUIFilter outputItem) {
        this.outputItem = outputItem;
    }

    @NotNull
    public ProvidedUIFilter getInputIngot() {
        return this.inputIngot;
    }

    public void setInputIngot(@NotNull ProvidedUIFilter inputIngot) {
        this.inputIngot = inputIngot;
    }

    @NotNull
    public ProvidedUIFilter getOutputIngot() {
        return this.outputIngot;
    }

    public void setOutputIngot(@NotNull ProvidedUIFilter outputIngot) {
        this.outputIngot = outputIngot;
    }

    @NotNull
    public ConfigurationSection getSection() {
        return this.section;
    }

    public RMGRI_Smithing(@NotNull ConfigurationSection recipeNameSection) {
        this.section = recipeNameSection;
        String input = RMGRI_Smithing.updateIngredients(this.section.getString("input"));
        String output = RMGRI_Smithing.updateIngredients(this.section.getString("output"));
        String[] inputSplit = input.split("\\|");
        String[] outputSplit = output.split("\\|");
        ProvidedUIFilter inputItemParse = ProvidedUIFilter.getFromString((String)inputSplit[0], null);
        ProvidedUIFilter outputItemParse = ProvidedUIFilter.getFromString((String)outputSplit[0], null);
        ProvidedUIFilter inputIngotParse = ProvidedUIFilter.getFromString((String)inputSplit[1], null);
        ProvidedUIFilter outputIngotParse = ProvidedUIFilter.getFromString((String)outputSplit[1], null);
        this.inputItem = inputItemParse != null ? inputItemParse : RecipeEditorGUI.AIR.clone();
        this.inputIngot = inputIngotParse != null ? inputIngotParse : RecipeEditorGUI.AIR.clone();
        this.outputItem = outputItemParse != null ? outputItemParse : RecipeEditorGUI.AIR.clone();
        this.outputIngot = outputIngotParse != null ? outputIngotParse : RecipeEditorGUI.AIR.clone();
    }

    public void setInput(int slot, @NotNull ProvidedUIFilter poof) {
        if (slot == 0) {
            this.setInputItem(poof);
        } else if (slot == 1) {
            this.setInputIngot(poof);
        }
    }

    @Override
    @Nullable
    public ProvidedUIFilter getInput(int slot) {
        if (slot == 0) {
            return this.getInputItem();
        }
        if (slot == 1) {
            return this.getInputIngot();
        }
        return null;
    }

    public void setOutput(int slot, @NotNull ProvidedUIFilter poof) {
        if (slot == 0) {
            this.setOutputItem(poof);
        } else if (slot == 1) {
            this.setOutputIngot(poof);
        }
    }

    @Override
    @Nullable
    public ProvidedUIFilter getOutput(int slot) {
        if (slot == 0) {
            return this.getOutputItem();
        }
        if (slot == 1) {
            return this.getOutputIngot();
        }
        return null;
    }

    @Override
    public void editInput(@NotNull ProvidedUIFilter input, int slot) {
        this.setInput(slot, input);
        this.section.set("input", (Object)this.toYML(this.getInputItem(), this.getInputIngot()));
    }

    @Override
    public void editOutput(@NotNull ProvidedUIFilter input, int slot) {
        this.setOutput(slot, input);
        this.section.set("output", (Object)this.toYML(this.getOutputItem(), this.getOutputIngot()));
    }

    @Override
    public void deleteInput(int slot) {
        this.editInput(RecipeEditorGUI.AIR.clone(), slot);
    }

    @Override
    public void deleteOutput(int slot) {
        this.editOutput(RecipeEditorGUI.AIR.clone(), slot);
    }

    @NotNull
    public static String updateIngredients(@Nullable String curr) {
        if (curr == null || curr.isEmpty()) {
            return emptyIngredients;
        }
        if (curr.contains("|")) {
            String[] curSplit = curr.split("\\|");
            if (curSplit.length == 2) {
                return curr;
            }
            StringBuilder ret = new StringBuilder();
            for (int r = 0; r < 2; ++r) {
                if (r != 0) {
                    ret.append("|");
                }
                if (r < curSplit.length) {
                    ret.append(RecipeEditorGUI.poofFromLegacy(curSplit[r]));
                    continue;
                }
                ret.append("v AIR -");
            }
            return ret.toString();
        }
        if (curr.contains(" ")) {
            StringBuilder ret = new StringBuilder();
            String[] curSplit = curr.split(" ");
            for (int r = 0; r < 2; ++r) {
                if (r != 0) {
                    ret.append("|");
                }
                if (r < curSplit.length) {
                    ret.append(RecipeEditorGUI.poofFromLegacy(curSplit[r]));
                    continue;
                }
                ret.append("v AIR -");
            }
            return ret.toString();
        }
        return RecipeEditorGUI.poofFromLegacy(curr) + "|v AIR 0";
    }
}

