/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui.edition.recipe.interpreter;

import io.lumine.mythic.lib.api.crafting.uimanager.ProvidedUIFilter;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import java.util.List;
import net.Indyuce.mmoitems.gui.edition.recipe.gui.RecipeEditorGUI;
import net.Indyuce.mmoitems.gui.edition.recipe.interpreter.RMG_RecipeInterpreter;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RMGRI_Shaped
implements RMG_RecipeInterpreter {
    @NotNull
    final ProvidedUIFilter[][] inputRecipe;
    @NotNull
    final ProvidedUIFilter[][] outputRecipe;
    @NotNull
    final ConfigurationSection section;
    public static final String emptyRow = "v AIR 0|v AIR 0|v AIR 0";

    @NotNull
    ProvidedUIFilter[][] buildIngredientsFromList(@NotNull List<String> config) {
        ProvidedUIFilter[][] ret = new ProvidedUIFilter[3][3];
        for (int r = 0; r < 3; ++r) {
            String row = config.size() > r ? config.get(r) : null;
            String s = RMGRI_Shaped.updateRow(row);
            String[] poofs = s.split("\\|");
            for (int p = 0; p < 3; ++p) {
                String poof = poofs.length > p ? poofs[p] : null;
                ProvidedUIFilter parsed = ProvidedUIFilter.getFromString((String)poof, null);
                if (parsed == null) {
                    parsed = RecipeEditorGUI.AIR.clone();
                }
                ret[r][p] = parsed;
            }
        }
        return ret;
    }

    @NotNull
    ArrayList<String> toYML(@NotNull ProvidedUIFilter[][] ingredients) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int r = 0; r < 3; ++r) {
            ProvidedUIFilter[] poofs = ingredients.length > r ? ingredients[r] : new ProvidedUIFilter[3];
            StringBuilder sb = new StringBuilder();
            for (ProvidedUIFilter poof : poofs) {
                ProvidedUIFilter providedUIFilter = poof;
                if (providedUIFilter == null) {
                    providedUIFilter = RecipeEditorGUI.AIR.clone();
                }
                if (sb.length() != 0) {
                    sb.append("|");
                }
                sb.append(providedUIFilter);
            }
            ret.add(sb.toString());
        }
        return ret;
    }

    public void setInput(int slot, @NotNull ProvidedUIFilter poof) {
        if (slot < 0 || slot > 8) {
            return;
        }
        this.inputRecipe[SilentNumbers.floor((double)((double)slot / 3.0))][slot - 3 * SilentNumbers.floor((double)((double)slot / 3.0))] = poof;
    }

    @Override
    @Nullable
    public ProvidedUIFilter getInput(int slot) {
        if (slot < 0 || slot > 8) {
            return null;
        }
        return this.inputRecipe[SilentNumbers.floor((double)((double)slot / 3.0))][slot - 3 * SilentNumbers.floor((double)((double)slot / 3.0))];
    }

    public void setOutput(int slot, @NotNull ProvidedUIFilter poof) {
        if (slot < 0 || slot > 8) {
            return;
        }
        this.outputRecipe[SilentNumbers.floor((double)((double)slot / 3.0))][slot - 3 * SilentNumbers.floor((double)((double)slot / 3.0))] = poof;
    }

    @Override
    @Nullable
    public ProvidedUIFilter getOutput(int slot) {
        if (slot < 0 || slot > 8) {
            return null;
        }
        return this.outputRecipe[SilentNumbers.floor((double)((double)slot / 3.0))][slot - 3 * SilentNumbers.floor((double)((double)slot / 3.0))];
    }

    @NotNull
    public ConfigurationSection getSection() {
        return this.section;
    }

    public RMGRI_Shaped(@NotNull ConfigurationSection recipeNameSection) {
        this.section = recipeNameSection;
        this.inputRecipe = this.buildIngredientsFromList(this.section.getStringList("input"));
        this.outputRecipe = this.buildIngredientsFromList(this.section.getStringList("output"));
    }

    @Override
    public void editInput(@NotNull ProvidedUIFilter input, int slot) {
        this.setInput(slot, input);
        this.section.set("input", this.toYML(this.inputRecipe));
    }

    @Override
    public void editOutput(@NotNull ProvidedUIFilter input, int slot) {
        this.setOutput(slot, input);
        this.section.set("output", this.toYML(this.outputRecipe));
    }

    @Override
    public void deleteInput(int slot) {
        this.editInput(RecipeEditorGUI.AIR.clone(), slot);
    }

    @Override
    public void deleteOutput(int slot) {
        this.editOutput(RecipeEditorGUI.AIR.clone(), slot);
    }

    @NotNull
    public static String updateRow(@Nullable String curr) {
        if (curr == null || curr.isEmpty()) {
            return emptyRow;
        }
        if (curr.contains("|")) {
            String[] curSplit = curr.split("\\|");
            if (curSplit.length == 3) {
                return curr;
            }
            StringBuilder ret = new StringBuilder();
            for (int r = 0; r < 3; ++r) {
                if (r != 0) {
                    ret.append("|");
                }
                if (r < curSplit.length) {
                    ret.append(RecipeEditorGUI.poofFromLegacy(curSplit[r]));
                    continue;
                }
                ret.append("v AIR 0");
            }
            return ret.toString();
        }
        if (curr.contains(" ")) {
            StringBuilder ret = new StringBuilder();
            String[] curSplit = curr.split(" ");
            for (int r = 0; r < 3; ++r) {
                if (r != 0) {
                    ret.append("|");
                }
                if (r < curSplit.length) {
                    ret.append(RecipeEditorGUI.poofFromLegacy(curSplit[r]));
                    continue;
                }
                ret.append("v AIR 0");
            }
            return ret.toString();
        }
        return RecipeEditorGUI.poofFromLegacy(curr) + "|v AIR 0|v AIR 0";
    }
}

