/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui.edition.recipe.button;

import io.lumine.mythic.lib.api.util.ItemFactory;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import net.Indyuce.mmoitems.api.crafting.recipe.SmithingCombinationType;
import net.Indyuce.mmoitems.gui.edition.recipe.button.type.RBA_ChooseableButton;
import net.Indyuce.mmoitems.gui.edition.recipe.gui.RecipeEditorGUI;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RBA_SmithingUpgrades
extends RBA_ChooseableButton {
    @NotNull
    final ItemStack chooseableButton = ItemFactory.of((Material)Material.ANVIL).name("\u00a7aUpgrades Transfer").lore((Iterable)SilentNumbers.chop((String)"What will happen to the upgrades of the ingredients? Will upgraded ingredients produce an upgraded output item?", (int)65, (String)"\u00a77")).build();
    public static final String SMITH_UPGRADES = "upgrades";
    static ArrayList<String> smithingList;

    public RBA_SmithingUpgrades(@NotNull RecipeEditorGUI inv) {
        super(inv);
    }

    @Override
    @NotNull
    public ItemStack getChooseableButton() {
        return this.chooseableButton;
    }

    @Override
    @NotNull
    public String getChooseableConfigPath() {
        return SMITH_UPGRADES;
    }

    @Override
    @NotNull
    public ArrayList<String> getChooseableList() {
        return RBA_SmithingUpgrades.getSmithingList();
    }

    @Override
    @NotNull
    public String getDefaultValue() {
        return SmithingCombinationType.MAXIMUM.toString();
    }

    @Override
    @NotNull
    public String getChooseableDefinition(@NotNull String ofChooseable) {
        SmithingCombinationType sct = SmithingCombinationType.MAXIMUM;
        try {
            sct = SmithingCombinationType.valueOf(this.getCurrentChooseableValue());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        switch (sct) {
            case EVEN: {
                return "Will take the average of the upgrade levels of the combined items.";
            }
            case NONE: {
                return "Will ignore the upgrade levels of any ingredients.";
            }
            case MAXIMUM: {
                return "Output will have the upgrade level of the most upgraded ingredient.";
            }
            case MINIMUM: {
                return "Output will have the upgrade level of the least-upgraded upgradeable ingredient.";
            }
            case ADDITIVE: {
                return "The upgrade levels of the ingredients will be added, and the result will be the crafted item's level.";
            }
        }
        return "Unknown behaviour. Add description in net.Indyuce.mmoitems.gui.edition.recipe.rba.RBA_SmithingUpgrades";
    }

    @NotNull
    static ArrayList<String> getSmithingList() {
        if (smithingList != null) {
            return smithingList;
        }
        smithingList = new ArrayList();
        for (SmithingCombinationType sct : SmithingCombinationType.values()) {
            smithingList.add(sct.toString());
        }
        return smithingList;
    }
}

