/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui.edition.recipe.button;

import io.lumine.mythic.lib.api.util.ItemFactory;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import net.Indyuce.mmoitems.api.crafting.recipe.SmithingCombinationType;
import net.Indyuce.mmoitems.gui.edition.recipe.button.RBA_SmithingUpgrades;
import net.Indyuce.mmoitems.gui.edition.recipe.button.type.RBA_ChooseableButton;
import net.Indyuce.mmoitems.gui.edition.recipe.gui.RecipeEditorGUI;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RBA_SmithingEnchantments
extends RBA_ChooseableButton {
    @NotNull
    final ItemStack chooseableButton = ItemFactory.of((Material)Material.ENCHANTING_TABLE).name("\u00a7aEnchantment Transfer").lore((Iterable)SilentNumbers.chop((String)"What will happen to the enchantments of the ingredients? Will enchanted ingredients produce an enchanted output item?", (int)65, (String)"\u00a77")).build();
    public static final String SMITH_ENCHANTS = "enchantments";

    public RBA_SmithingEnchantments(@NotNull RecipeEditorGUI inv) {
        super(inv);
    }

    @Override
    @NotNull
    public ItemStack getChooseableButton() {
        return this.chooseableButton;
    }

    @Override
    @NotNull
    public String getChooseableConfigPath() {
        return SMITH_ENCHANTS;
    }

    @Override
    @NotNull
    public ArrayList<String> getChooseableList() {
        return RBA_SmithingUpgrades.getSmithingList();
    }

    @Override
    @NotNull
    public String getDefaultValue() {
        return SmithingCombinationType.MAXIMUM.toString();
    }

    @Override
    @NotNull
    public String getChooseableDefinition(@NotNull String ofChooseable) {
        SmithingCombinationType sct = SmithingCombinationType.MAXIMUM;
        try {
            sct = SmithingCombinationType.valueOf(this.getCurrentChooseableValue());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        switch (sct) {
            case EVEN: {
                return "For each enchantment, will take the average of that enchantment's level across the ingredients.";
            }
            case NONE: {
                return "Will ignore the enchantments of any ingredients.";
            }
            case MAXIMUM: {
                return "Output will have the best enchantment from each ingredient";
            }
            case MINIMUM: {
                return "Output will have worst enchantment from each ingredient with that enchantment.";
            }
            case ADDITIVE: {
                return "The enchantments of all ingredients will add together.";
            }
        }
        return "Unknown behaviour. Add description in net.Indyuce.mmoitems.gui.edition.recipe.rba.RBA_SmithingEnchantments";
    }
}

