/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui.edition.recipe.button;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.util.ItemFactory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackPalette;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.Objects;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import net.Indyuce.mmoitems.gui.edition.recipe.button.RecipeButtonAction;
import net.Indyuce.mmoitems.gui.edition.recipe.gui.RecipeEditorGUI;
import net.Indyuce.mmoitems.stat.HidePotionEffects;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.jetbrains.annotations.NotNull;

public class RBA_AmountOutput
extends RecipeButtonAction {
    @NotNull
    public final String[] amountLog = new String[]{FriendlyFeedbackProvider.quickForPlayer((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Write in the chat the amount of output of this recipe.", (String[])new String[0]), FriendlyFeedbackProvider.quickForPlayer((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"It must be an integer number, ex $e4$b.", (String[])new String[0])};
    @NotNull
    final ItemStack button;
    public static final String AMOUNT_INGREDIENTS = "amount";

    public RBA_AmountOutput(@NotNull RecipeEditorGUI inv, @NotNull ItemStack resultItem) {
        super(inv);
        this.button = RecipeEditorGUI.rename(ItemFactory.of((Material)resultItem.getType()).lore((Iterable)SilentNumbers.chop((String)"The amount of items produced every time the player crafts.", (int)65, (String)"\u00a77")).build(), "\u00a7cChoose Output Amount");
        ItemMeta buttonMeta = Objects.requireNonNull(this.button.getItemMeta());
        ItemMeta resultMeta = Objects.requireNonNull(resultItem.getItemMeta());
        if (MythicLib.plugin.getVersion().isStrictlyHigher(new int[]{1, 13}) && resultMeta.hasCustomModelData()) {
            buttonMeta.setCustomModelData(Integer.valueOf(resultMeta.getCustomModelData()));
        }
        if (resultMeta instanceof LeatherArmorMeta) {
            ((LeatherArmorMeta)buttonMeta).setColor(((LeatherArmorMeta)resultMeta).getColor());
        }
        if (resultMeta instanceof BannerMeta) {
            ((BannerMeta)buttonMeta).setPatterns(((BannerMeta)resultMeta).getPatterns());
        }
        buttonMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_DYE, HidePotionEffects.ITEM_FLAG});
        this.button.setItemMeta(buttonMeta);
    }

    @Override
    public boolean runPrimary() {
        new StatEdition(this.inv, ItemStats.CRAFTING, 2, this).enable(this.amountLog);
        return true;
    }

    @Override
    public void primaryProcessInput(@NotNull String message, Object ... info) throws IllegalArgumentException {
        Integer val = SilentNumbers.IntegerParse((String)message);
        if (val == null) {
            throw new IllegalArgumentException("Expected an integer number instead of $u" + message);
        }
        if (val > 64) {
            throw new IllegalArgumentException("Max stack size is $e64$b, Minecraft doesnt support $u" + message);
        }
        if (val <= 0) {
            throw new IllegalArgumentException("Min output stack size is $e0$b, you specified $u" + message);
        }
        this.getInv().getNameSection().set(AMOUNT_INGREDIENTS, (Object)val);
    }

    @Override
    public boolean runSecondary() {
        this.getInv().getNameSection().set(AMOUNT_INGREDIENTS, null);
        this.clickSFX();
        this.inv.registerTemplateEdition();
        return true;
    }

    public int getOutputAmount() {
        return this.getInv().getNameSection().getInt(AMOUNT_INGREDIENTS, 1);
    }

    @Override
    public void secondaryProcessInput(@NotNull String message, Object ... info) throws IllegalArgumentException {
    }

    @Override
    @NotNull
    public ItemStack getButton() {
        ItemStack ret = this.button.clone();
        ret.setAmount(this.getOutputAmount());
        return RecipeEditorGUI.addLore(ret, SilentNumbers.toArrayList((Object[])new String[]{"", ChatColor.YELLOW + "\u25ba" + " Right click to reset to 1.", ChatColor.YELLOW + "\u25ba" + " Left click to edit amount."}));
    }
}

