/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui.edition.recipe;

import io.lumine.mythic.lib.api.util.ItemFactory;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import io.lumine.mythic.lib.version.VersionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.gui.edition.recipe.gui.RecipeEditorGUI;
import net.Indyuce.mmoitems.gui.edition.recipe.registry.RecipeRegistry;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RecipeListGUI
extends EditionInventory {
    @NotNull
    final ItemStack nextPage = ItemFactory.of((Material)Material.ARROW).name("\u00a77Next Page").build();
    @NotNull
    final ItemStack prevPage = ItemFactory.of((Material)Material.ARROW).name("\u00a77Previous Page").build();
    @NotNull
    final ItemStack noRecipe = ItemFactory.of((Material)Material.BLACK_STAINED_GLASS_PANE).name("\u00a77No Recipe").build();
    @NotNull
    final RecipeRegistry recipeType;
    @NotNull
    final ItemStack listedItem;
    @NotNull
    final ArrayList<String> recipeNames = new ArrayList();
    boolean invalidRecipe;
    int createSlot = -1;
    @NotNull
    final HashMap<Integer, String> recipeMap = new HashMap();

    @NotNull
    public RecipeRegistry getRecipeRegistry() {
        return this.recipeType;
    }

    @NotNull
    public ItemStack getListedItem() {
        return this.listedItem;
    }

    @NotNull
    public ArrayList<String> getRecipeNames() {
        return this.recipeNames;
    }

    public RecipeListGUI(@NotNull Player player, @NotNull MMOItemTemplate template, @NotNull RecipeRegistry kind) {
        super(player, template);
        this.recipeType = kind;
        this.listedItem = this.getRecipeRegistry().getDisplayListItem();
        ConfigurationSection section = RecipeEditorGUI.getSection(this.getEditedSection(), "crafting");
        ConfigurationSection type = RecipeEditorGUI.getSection(section, kind.getRecipeConfigPath());
        this.recipeNames.addAll(type.getKeys(false));
        this.page = 0;
    }

    @Override
    public String getName() {
        return "Choose " + this.getRecipeRegistry().getRecipeTypeName() + " Recipe";
    }

    @Override
    public void arrangeInventory() {
        this.recipeMap.clear();
        this.createSlot = -1;
        if (this.page > 0) {
            this.inventory.setItem(27, this.prevPage);
        }
        if (this.recipeNames.size() >= (this.page + 1) * 21) {
            this.inventory.setItem(36, this.nextPage);
        }
        for (int p = 21 * this.page; p < 21 * (this.page + 1); ++p) {
            int absolute = RecipeListGUI.page(p);
            if (p == this.recipeNames.size()) {
                this.inventory.setItem(absolute, RecipeEditorGUI.rename(new ItemStack(Material.NETHER_STAR), FFPMMOItems.get().getBodyFormat() + "Create new " + SilentNumbers.getItemName((ItemStack)this.getListedItem(), (boolean)false)));
                this.createSlot = absolute;
                continue;
            }
            if (p > this.recipeNames.size()) {
                this.inventory.setItem(absolute, this.noRecipe);
                continue;
            }
            this.inventory.setItem(absolute, RecipeEditorGUI.rename(this.getListedItem().clone(), FFPMMOItems.get().getBodyFormat() + "Edit " + FFPMMOItems.get().getInputFormat() + this.recipeNames.get(p)));
            this.recipeMap.put(absolute, this.recipeNames.get(p));
        }
    }

    public static int page(int p) {
        int red = SilentNumbers.floor((double)((double)p / 21.0));
        int relRow = SilentNumbers.floor((double)((double)(p -= red * 21) / 7.0));
        int relCol = p - 7 * relRow;
        int rowAdditive = 18 + relRow * 9;
        int columnAdditive = relCol + 1;
        return rowAdditive + columnAdditive;
    }

    @Override
    public void whenClicked(InventoryClickEvent event) {
        String recipeName;
        if (VersionUtils.getView((InventoryEvent)event).getTopInventory() != event.getClickedInventory()) {
            return;
        }
        event.setCancelled(true);
        if (this.invalidRecipe) {
            return;
        }
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            String recipeName2;
            if (event.getSlot() == 27) {
                --this.page;
                this.refreshInventory();
            } else if (event.getSlot() == 36) {
                ++this.page;
                this.refreshInventory();
            } else if (event.getSlot() == this.createSlot) {
                String chadName = String.valueOf(this.recipeMap.size() + 1);
                if (this.recipeMap.containsValue(chadName)) {
                    chadName = chadName + "_" + UUID.randomUUID();
                }
                this.getRecipeRegistry().openForPlayer(this, chadName, new Object[0]);
            } else if (event.getSlot() > 18 && (recipeName2 = this.recipeMap.get(event.getSlot())) != null) {
                this.getRecipeRegistry().openForPlayer(this, recipeName2, new Object[0]);
            }
        } else if (event.getAction() == InventoryAction.PICKUP_HALF && (recipeName = this.recipeMap.get(event.getSlot())) != null) {
            ConfigurationSection section = RecipeEditorGUI.getSection(this.getEditedSection(), "crafting");
            ConfigurationSection type = RecipeEditorGUI.getSection(section, this.getRecipeRegistry().getRecipeConfigPath());
            this.recipeNames.remove(recipeName);
            type.set(recipeName, null);
            this.registerTemplateEdition();
        }
    }
}

