/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui.edition;

import io.lumine.mythic.lib.UtilityMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.CustomSound;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SoundsEdition
extends EditionInventory {
    public static final Map<Integer, String> CORRESPONDING_SLOT = new HashMap<Integer, String>();

    public SoundsEdition(Player player, MMOItemTemplate template) {
        super(player, template);
    }

    @Override
    public String getName() {
        return "Custom Sounds: " + this.template.getId();
    }

    @Override
    public void arrangeInventory() {
        for (CustomSound sound : CustomSound.values()) {
            ItemStack soundEvent = sound.getItem().clone();
            ItemMeta soundEventMeta = soundEvent.getItemMeta();
            soundEventMeta.addItemFlags(ItemFlag.values());
            soundEventMeta.setDisplayName(ChatColor.GREEN + sound.getName());
            ArrayList<String> eventLore = new ArrayList<String>();
            for (String lore : sound.getLore()) {
                eventLore.add(ChatColor.GRAY + lore);
            }
            eventLore.add("");
            String configSoundName = sound.getName().replace(" ", "-").toLowerCase();
            String value = this.getEditedSection().getString("sounds." + configSoundName + ".sound");
            if (value != null) {
                eventLore.add(ChatColor.GRAY + "Current Values:");
                eventLore.add(ChatColor.GRAY + " - Sound Name: '" + ChatColor.GREEN + this.getEditedSection().getString("sounds." + configSoundName + ".sound") + ChatColor.GRAY + "'");
                eventLore.add(ChatColor.GRAY + " - Volume: " + ChatColor.GREEN + this.getEditedSection().getDouble("sounds." + configSoundName + ".volume"));
                eventLore.add(ChatColor.GRAY + " - Pitch: " + ChatColor.GREEN + this.getEditedSection().getDouble("sounds." + configSoundName + ".pitch"));
            } else {
                eventLore.add(ChatColor.GRAY + "Current Values: " + ChatColor.RED + "None");
            }
            eventLore.add("");
            eventLore.add(ChatColor.YELLOW + "\u25ba" + " Click to change this value.");
            eventLore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove this value.");
            soundEventMeta.setLore(eventLore);
            soundEvent.setItemMeta(soundEventMeta);
            this.inventory.setItem(sound.getSlot(), soundEvent);
        }
    }

    @Override
    public void whenClicked(InventoryClickEvent event) {
        ItemStack item = event.getCurrentItem();
        event.setCancelled(true);
        if (event.getInventory() != event.getClickedInventory() || !MMOUtils.isMetaItem(item, false)) {
            return;
        }
        if (CORRESPONDING_SLOT.containsKey(event.getSlot())) {
            if (event.getAction() == InventoryAction.PICKUP_ALL) {
                new StatEdition(this, ItemStats.CUSTOM_SOUNDS, CORRESPONDING_SLOT.get(event.getSlot())).enable("Write in the chat the custom sound you want to add.", ChatColor.AQUA + "Format: [SOUND NAME] [VOLUME] [PITCH]", ChatColor.AQUA + "Example: entity.generic.drink 1 1");
            }
            if (event.getAction() == InventoryAction.PICKUP_HALF) {
                String soundPath = CORRESPONDING_SLOT.get(event.getSlot());
                this.getEditedSection().set("sounds." + soundPath, null);
                if (this.getEditedSection().contains("sounds." + soundPath) && this.getEditedSection().getConfigurationSection("sounds." + soundPath).getKeys(false).isEmpty()) {
                    this.getEditedSection().set("sounds." + soundPath, null);
                    if (this.getEditedSection().getConfigurationSection("sounds").getKeys(false).isEmpty()) {
                        this.getEditedSection().set("sounds", null);
                    }
                }
                this.registerTemplateEdition();
                this.player.sendMessage(MMOItems.plugin.getPrefix() + ChatColor.RED + UtilityMethods.caseOnWords((String)soundPath.replace("-", " ")) + " Sound" + ChatColor.GRAY + " successfully removed.");
            }
        }
    }

    static {
        for (CustomSound sound : CustomSound.values()) {
            CORRESPONDING_SLOT.put(sound.getSlot(), sound.name().replace("_", "-").toLowerCase());
        }
    }
}

