/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui.edition;

import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackPalette;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.version.VInventoryView;
import io.lumine.mythic.lib.version.VersionUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ConfigFile;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.item.template.ModifierNode;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import net.Indyuce.mmoitems.gui.PluginInventory;
import net.Indyuce.mmoitems.stat.data.random.RandomStatData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditionInventory
extends PluginInventory {
    @Nullable
    protected Inventory inventory;
    protected MMOItemTemplate template;
    private final ConfigFile configFile;
    private final boolean displaysBack;
    @Deprecated
    private ModifierNode editedModifier = null;
    private ItemStack cachedItem;
    private int previousPage;
    @NotNull
    final FriendlyFeedbackProvider ffp;

    public EditionInventory(@NotNull Player player, @NotNull MMOItemTemplate template) {
        this(player, template, true);
    }

    public EditionInventory(@NotNull Player player, @NotNull MMOItemTemplate template, boolean displaysBack) {
        super(player);
        this.displaysBack = displaysBack;
        this.ffp = new FriendlyFeedbackProvider((FriendlyFeedbackPalette)FFPMMOItems.get());
        this.ffp.activatePrefix(true, "Edition");
        this.template = template;
        this.configFile = template.getType().getConfigFile();
        VInventoryView open = VersionUtils.getOpen((Player)player);
        if (open.getTopInventory().getHolder() instanceof EditionInventory) {
            this.cachedItem = ((EditionInventory)open.getTopInventory().getHolder()).cachedItem;
        }
    }

    @Override
    public Inventory getInventory() {
        return this.inventory;
    }

    public abstract void arrangeInventory();

    public void refreshInventory() {
        Validate.notNull((Object)this.inventory, (String)"Inventory has never been opened");
        this.inventory.clear();
        this.addEditionItems();
        this.arrangeInventory();
    }

    public void open(@Nullable EditionInventory previousInventory) {
        this.previousPage = previousInventory == null ? 0 : previousInventory.previousPage;
        this.open();
    }

    @Deprecated
    public void open(int previousPage) {
        this.previousPage = previousPage;
        this.open();
    }

    @Override
    public void open() {
        if (this.inventory == null) {
            this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)this.getName());
        }
        this.addEditionItems();
        this.arrangeInventory();
        super.open();
    }

    public abstract String getName();

    public MMOItemTemplate getEdited() {
        return this.template;
    }

    public ConfigurationSection getEditedSection() {
        ConfigurationSection config = this.configFile.getConfig().getConfigurationSection(this.template.getId());
        Validate.notNull((Object)config, (String)("Could not find config section associated to the template '" + this.template.getType().getId() + "." + this.template.getId() + "': make sure the config section name is in capital letters"));
        return config.getConfigurationSection(this.editedModifier == null ? "base" : "modifiers." + this.editedModifier.getId() + ".stats");
    }

    public <R extends RandomStatData<S>, S extends StatData> Optional<R> getEventualStatData(ItemStat<R, S> stat) {
        Map<ItemStat, RandomStatData> map = this.editedModifier != null ? this.editedModifier.getItemData() : this.template.getBaseItemData();
        return map.containsKey(stat) ? Optional.of(map.get(stat)) : Optional.empty();
    }

    public void registerTemplateEdition() {
        this.configFile.registerTemplateEdition(this.template);
        this.template = MMOItems.plugin.getTemplates().getTemplate(this.template.getType(), this.template.getId());
        this.updateCachedItem();
        this.refreshInventory();
    }

    public void updateCachedItem() {
        this.cachedItem = this.template.newBuilder(PlayerData.get((OfflinePlayer)this.getPlayer()).getRPG()).build().newBuilder().buildSilently();
    }

    public ItemStack getCachedItem() {
        if (this.cachedItem != null) {
            return this.cachedItem;
        }
        this.updateCachedItem();
        return this.cachedItem;
    }

    public void addEditionItems() {
        ItemStack get = new ItemStack(Material.CHEST);
        ItemMeta getMeta = get.getItemMeta();
        getMeta.addItemFlags(ItemFlag.values());
        getMeta.setDisplayName(ChatColor.GREEN + "\u2724" + " Get the Item! " + "\u2724");
        ArrayList<String> getLore = new ArrayList<String>();
        getLore.add(ChatColor.GRAY + "");
        getLore.add(ChatColor.GRAY + "You may also use /mi give " + this.template.getType().getId() + " " + this.template.getId());
        getLore.add(ChatColor.GRAY + "");
        getLore.add(ChatColor.YELLOW + "\u25b8" + " Left click to get the item.");
        getLore.add(ChatColor.YELLOW + "\u25b8" + " Right click to reroll its stats.");
        getMeta.setLore(getLore);
        get.setItemMeta(getMeta);
        if (this.displaysBack) {
            ItemStack back = new ItemStack(Material.BARRIER);
            ItemMeta backMeta = back.getItemMeta();
            backMeta.setDisplayName(ChatColor.GREEN + "\u21e8" + " Back");
            back.setItemMeta(backMeta);
            this.inventory.setItem(6, back);
        }
        this.inventory.setItem(2, get);
        this.inventory.setItem(4, this.getCachedItem());
    }

    public int getPreviousPage() {
        return this.previousPage;
    }

    @NotNull
    public FriendlyFeedbackProvider getFFP() {
        return this.ffp;
    }
}

