/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui.edition;

import java.util.ArrayList;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CommandListEdition
extends EditionInventory {
    private static final int[] slots = new int[]{19, 20, 21, 22, 23, 24, 25, 28, 29, 33, 34, 37, 38, 42, 43};
    private static final NamespacedKey CONFIG_KEY = new NamespacedKey((Plugin)MMOItems.plugin, "ConfigKey");

    public CommandListEdition(Player player, MMOItemTemplate template) {
        super(player, template);
    }

    @Override
    public String getName() {
        return "Command List";
    }

    @Override
    public void arrangeInventory() {
        int n = 0;
        if (this.getEditedSection().contains("commands")) {
            for (String key : this.getEditedSection().getConfigurationSection("commands").getKeys(false)) {
                String format = this.getEditedSection().getString("commands." + key + ".format");
                double delay = this.getEditedSection().getDouble("commands." + key + ".delay");
                boolean console = this.getEditedSection().getBoolean("commands." + key + ".console");
                boolean op = this.getEditedSection().getBoolean("commands." + key + ".op");
                ItemStack item = new ItemStack(Material.COMPARATOR);
                ItemMeta itemMeta = item.getItemMeta();
                itemMeta.setDisplayName(format == null || format.equals("") ? ChatColor.RED + "No Format" : ChatColor.GREEN + format);
                ArrayList<String> itemLore = new ArrayList<String>();
                itemLore.add("");
                itemLore.add(ChatColor.GRAY + "Command Delay: " + ChatColor.RED + delay);
                itemLore.add(ChatColor.GRAY + "Sent by Console: " + ChatColor.RED + console);
                itemLore.add(ChatColor.GRAY + "Sent w/ OP perms: " + ChatColor.RED + op);
                itemLore.add("");
                itemLore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove.");
                itemMeta.setLore(itemLore);
                itemMeta.getPersistentDataContainer().set(CONFIG_KEY, PersistentDataType.STRING, (Object)key);
                item.setItemMeta(itemMeta);
                this.inventory.setItem(slots[n++], item);
            }
        }
        ItemStack glass = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta glassMeta = glass.getItemMeta();
        glassMeta.setDisplayName(ChatColor.RED + "- No Command -");
        glass.setItemMeta(glassMeta);
        ItemStack add = new ItemStack(Material.WRITABLE_BOOK);
        ItemMeta addMeta = add.getItemMeta();
        addMeta.setDisplayName(ChatColor.GREEN + "Register a command...");
        add.setItemMeta(addMeta);
        this.inventory.setItem(40, add);
        while (n < slots.length) {
            this.inventory.setItem(slots[n++], glass);
        }
    }

    @Override
    public void whenClicked(InventoryClickEvent event) {
        ItemStack item = event.getCurrentItem();
        event.setCancelled(true);
        if (event.getInventory() != event.getClickedInventory() || !MMOUtils.isMetaItem(item, false)) {
            return;
        }
        if (item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Register a command...")) {
            new StatEdition(this, ItemStats.COMMANDS, new Object[0]).enable("Write in the chat the command you want to add.", "", "To add a delay, use " + ChatColor.RED + "-d:<delay>", "To make the command cast itself w/ console, use " + ChatColor.RED + "-c", "To make the command cast w/ OP perms, use " + ChatColor.RED + "-op", "", ChatColor.YELLOW + "Ex: -d:10.3 -op bc Hello, this is a test command.");
            return;
        }
        String tag = (String)item.getItemMeta().getPersistentDataContainer().get(CONFIG_KEY, PersistentDataType.STRING);
        if (tag == null || tag.equals("")) {
            return;
        }
        if (event.getAction() == InventoryAction.PICKUP_HALF && this.getEditedSection().contains("commands") && this.getEditedSection().getConfigurationSection("commands").contains(tag)) {
            this.getEditedSection().set("commands." + tag, null);
            this.registerTemplateEdition();
            this.player.sendMessage(MMOItems.plugin.getPrefix() + "Successfully removed " + ChatColor.GOLD + tag + ChatColor.DARK_GRAY + " (Internal ID)" + ChatColor.GRAY + ".");
        }
    }
}

