/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.gui;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import java.util.List;
import net.Indyuce.mmoitems.api.crafting.ingredient.CheckedIngredient;
import net.Indyuce.mmoitems.api.crafting.recipe.CheckedRecipe;
import net.Indyuce.mmoitems.api.crafting.recipe.CraftingRecipe;
import net.Indyuce.mmoitems.api.crafting.recipe.UpgradingRecipe;
import net.Indyuce.mmoitems.api.item.util.ConfigItems;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.gui.CraftingStationView;
import net.Indyuce.mmoitems.gui.PluginInventory;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class CraftingStationPreview
extends PluginInventory {
    private final CraftingStationView previous;
    private final CheckedRecipe recipe;
    private final List<ItemStack> ingredients = new ArrayList<ItemStack>();
    private static final int[] slots = new int[]{12, 13, 14, 21, 22, 23, 30, 31, 32};
    private static final int[] fill = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 15, 17, 18, 19, 25, 26, 27, 29, 33, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};

    public CraftingStationPreview(CraftingStationView previous, CheckedRecipe recipe) {
        super(previous.getPlayer());
        this.previous = previous;
        this.recipe = recipe;
    }

    @Override
    @NotNull
    public Inventory getInventory() {
        ItemStack item;
        Inventory inv = Bukkit.createInventory((InventoryHolder)this, (int)45, (String)MythicLib.plugin.getPlaceholderParser().parse((OfflinePlayer)this.getPlayer(), Message.RECIPE_PREVIEW.format(ChatColor.RESET, new String[0]).toString()));
        this.ingredients.clear();
        for (CheckedIngredient ing : this.recipe.getIngredients()) {
            if (ing.getIngredient().getAmount() > 64) {
                ItemStack sample = ing.getIngredient().generateItemStack(this.playerData.getRPG(), true);
                sample.setAmount(64);
                int amount = ing.getIngredient().getAmount();
                int stacks = SilentNumbers.floor((double)((double)amount / 64.0));
                while (amount > 0) {
                    if (amount > 64) {
                        this.ingredients.add(sample.clone());
                        amount -= 64;
                        continue;
                    }
                    sample.setAmount(amount);
                    this.ingredients.add(sample.clone());
                    amount -= amount;
                }
                continue;
            }
            this.ingredients.add(ing.getIngredient().generateItemStack(this.playerData.getRPG(), true));
        }
        int min = (this.page - 1) * slots.length;
        int max = this.page * slots.length;
        for (int j = min; j < max && j < this.ingredients.size(); ++j) {
            inv.setItem(slots[j - min], this.ingredients.get(j));
        }
        for (int slot : fill) {
            inv.setItem(slot, ConfigItems.FILL.getItem());
        }
        if (this.recipe.getRecipe() instanceof CraftingRecipe) {
            item = ((CraftingRecipe)this.recipe.getRecipe()).getPreviewItemStack();
            item.setAmount(((CraftingRecipe)this.recipe.getRecipe()).getOutputAmount());
            inv.setItem(16, item);
        }
        if (this.recipe.getRecipe() instanceof UpgradingRecipe) {
            item = ((UpgradingRecipe)this.recipe.getRecipe()).getItem().getPreview();
            ItemMeta itemMeta = item.getItemMeta();
            itemMeta.setDisplayName(item.getItemMeta().getDisplayName() + ChatColor.GREEN + "+1!");
            item.setItemMeta(itemMeta);
            inv.setItem(16, item);
        }
        inv.setItem(10, ConfigItems.BACK.getItem());
        inv.setItem(34, ConfigItems.CONFIRM.getItem());
        ItemStack bookStack = this.recipe.display();
        bookStack.setType(Material.KNOWLEDGE_BOOK);
        bookStack.setAmount(1);
        ItemMeta meta = bookStack.getItemMeta();
        for (Enchantment ench : meta.getEnchants().keySet()) {
            meta.removeEnchant(ench);
        }
        meta.setLore(meta.getLore().subList(0, meta.getLore().size() - 3));
        bookStack.setItemMeta(meta);
        inv.setItem(28, bookStack);
        inv.setItem(20, this.page > 1 ? ConfigItems.PREVIOUS_PAGE.getItem() : ConfigItems.FILL.getItem());
        inv.setItem(24, max < this.ingredients.size() ? ConfigItems.NEXT_PAGE.getItem() : ConfigItems.FILL.getItem());
        return inv;
    }

    @Override
    public void whenClicked(InventoryClickEvent event) {
        event.setCancelled(true);
        if (!MMOUtils.isMetaItem(event.getCurrentItem(), false)) {
            return;
        }
        NBTItem nbtItem = MythicLib.plugin.getVersion().getWrapper().getNBTItem(event.getCurrentItem());
        switch (nbtItem.getString("ItemId")) {
            case "CONFIRM": {
                this.previous.processRecipe(this.recipe);
                this.previous.open();
                return;
            }
            case "PREVIOUS_PAGE": {
                --this.page;
                this.open();
                return;
            }
            case "NEXT_PAGE": {
                ++this.page;
                this.open();
                return;
            }
            case "BACK": {
                this.previous.open();
                return;
            }
        }
    }
}

