/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.comp.rpg;

import dev.aurelium.auraskills.api.AuraSkillsApi;
import dev.aurelium.auraskills.api.event.skill.SkillLevelUpEvent;
import dev.aurelium.auraskills.api.event.user.UserLoadEvent;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.stat.Stats;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitModifier;
import dev.aurelium.auraskills.api.trait.Traits;
import dev.aurelium.auraskills.api.user.SkillsUser;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.version.Sounds;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.player.EmptyRPGPlayer;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.player.RPGPlayer;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.comp.rpg.RPGHandler;
import net.Indyuce.mmoitems.stat.type.DoubleStat;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.stat.type.RequiredLevelStat;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class AuraSkillsHook
implements RPGHandler,
Listener {
    private AuraSkillsApi aSkills;
    private final Map<Stats, ItemStat> statExtra = new HashMap<Stats, ItemStat>();
    private static final String MODIFIER_KEY_PREFIX = "mmoitems_";

    public AuraSkillsHook() {
        this.aSkills = AuraSkillsApi.get();
        for (Stats stats : Stats.values()) {
            String statName = UtilityMethods.caseOnWords((String)stats.name().toLowerCase());
            DoubleStat miStat = new DoubleStat("ADDITIONAL_" + stats.name(), Material.BOOK, "Additional " + statName, new String[]{"Additional " + statName + " (AuraSkills)"}, new String[]{"!miscellaneous", "!block", "all"}, new Material[0]);
            this.statExtra.put(stats, miStat);
            MMOItems.plugin.getStats().register(miStat);
        }
        for (Stats stats : Skills.values()) {
            MMOItems.plugin.getStats().register(new RequiredProfessionStat((Skills)stats));
        }
    }

    @EventHandler
    public void a(SkillLevelUpEvent event) {
        Player player = event.getPlayer();
        if (player.isOnline()) {
            PlayerData.get((OfflinePlayer)player).getInventory().scheduleUpdate();
        }
    }

    @Override
    public void refreshStats(PlayerData data) {
        SkillsUser user = this.aSkills.getUser(data.getPlayer().getUniqueId());
        user.addTraitModifier(new TraitModifier("mmoitems_max_mana", (Trait)Traits.MAX_MANA, data.getStats().getStat(ItemStats.MAX_MANA)));
        double currentMaxMana = user.getMaxMana();
        if (user.getMana() > currentMaxMana) {
            user.setMana(currentMaxMana);
        }
        this.statExtra.forEach((stat, miStat) -> this.aSkills.getUser(data.getPlayer().getUniqueId()).addStatModifier(new StatModifier(MODIFIER_KEY_PREFIX + stat.name(), (Stat)stat, data.getStats().getStat((ItemStat<?, ?>)miStat))));
    }

    @Override
    public RPGPlayer getInfo(PlayerData data) {
        return new EmptyRPGPlayer(data);
    }

    @EventHandler
    public void a(UserLoadEvent event) {
        Player player = event.getPlayer();
        PlayerData playerData = PlayerData.get((OfflinePlayer)player);
        playerData.setRPGPlayer(new PlayerWrapper(playerData, event.getUser()));
    }

    private class RequiredProfessionStat
    extends RequiredLevelStat {
        private final Skill skill;

        public RequiredProfessionStat(Skills skill) {
            super(skill.name(), Material.EXPERIENCE_BOTTLE, skill.getDisplayName(Locale.getDefault()), new String[]{"Amount of " + skill.getDisplayName(Locale.getDefault()) + " levels the", "player needs to use the item.", "(AuraSkills)"});
            this.skill = AuraSkillsHook.this.aSkills.getGlobalRegistry().getSkill(skill.getId());
        }

        @Override
        public boolean canUse(RPGPlayer player, NBTItem item, boolean message) {
            int requirement = item.getInteger(this.getNBTPath());
            if (requirement <= 0) {
                return true;
            }
            int skillLevel = AuraSkillsHook.this.aSkills.getUser(player.getPlayer().getUniqueId()).getSkillLevel(this.skill);
            if (skillLevel >= requirement || player.getPlayer().hasPermission("mmoitems.bypass.level")) {
                return true;
            }
            if (message) {
                Message.NOT_ENOUGH_PROFESSION.format(ChatColor.RED, "#profession#", this.skill.getDisplayName(Locale.getDefault())).send(player.getPlayer());
                player.getPlayer().playSound(player.getPlayer().getLocation(), Sounds.ENTITY_VILLAGER_NO, 1.0f, 1.5f);
            }
            return false;
        }
    }

    private static class PlayerWrapper
    extends RPGPlayer {
        private final SkillsUser info;

        public PlayerWrapper(PlayerData playerData, SkillsUser rpgPlayerData) {
            super(playerData);
            this.info = rpgPlayerData;
        }

        @Override
        public int getLevel() {
            return this.info.getPowerLevel();
        }

        @Override
        public String getClassName() {
            return "";
        }

        @Override
        public double getMana() {
            return this.info.getMana();
        }

        @Override
        public double getStamina() {
            return this.getPlayer().getFoodLevel();
        }

        @Override
        public void setMana(double value) {
            this.info.setMana(value);
        }

        @Override
        public void setStamina(double value) {
            this.getPlayer().setFoodLevel((int)value);
        }
    }
}

