/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.comp.placeholders;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.manager.StatManager;
import io.lumine.mythic.lib.util.DefenseFormula;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MMOItemsPlaceholders
extends PlaceholderExpansion {
    public String getAuthor() {
        return "Indyuce";
    }

    public String getIdentifier() {
        return "mmoitems";
    }

    public String getVersion() {
        return MMOItems.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(@Nullable OfflinePlayer player, @NotNull String identifier) {
        if (identifier.startsWith("type_")) {
            String t = identifier.substring(5, identifier.lastIndexOf("_")).toUpperCase();
            if (!MMOItems.plugin.getTypes().has(t)) {
                return "Invalid type";
            }
            Type type = Type.get(t);
            String pholder = identifier.substring(6 + t.length()).toLowerCase();
            if ("total".equals(pholder)) {
                return "" + MMOItems.plugin.getTemplates().getTemplates(type).size();
            }
            return type.getName();
        }
        if (player == null) {
            return null;
        }
        if (identifier.equals("stat_defense_percent")) {
            double defenseStat = MMOPlayerData.get((OfflinePlayer)player).getStatMap().getStat("DEFENSE");
            double damageReduction = 100.0 - new DefenseFormula().getAppliedDamage(defenseStat, 100.0);
            return MythicLib.plugin.getMMOConfig().decimal.format(damageReduction);
        }
        if (identifier.startsWith("stat_")) {
            String stat = UtilityMethods.enumName((String)identifier.substring(5));
            return StatManager.format((String)stat, (MMOPlayerData)MMOPlayerData.get((OfflinePlayer)player));
        }
        if (identifier.startsWith("ability_cd_")) {
            return MythicLib.plugin.getMMOConfig().decimal.format(MMOPlayerData.get((OfflinePlayer)player).getCooldownMap().getCooldown("skill_" + identifier.substring(11)));
        }
        if (identifier.startsWith("tier_")) {
            String t = identifier.substring(5).toUpperCase();
            if (!MMOItems.plugin.getTiers().has(t)) {
                return "Invalid tier";
            }
            return MMOItems.plugin.getTiers().get(t).getName();
        }
        if (!player.isOnline()) {
            return null;
        }
        if (identifier.equals("durability")) {
            NBTItem nbt = MythicLib.plugin.getVersion().getWrapper().getNBTItem(player.getPlayer().getInventory().getItemInMainHand());
            return String.valueOf(nbt.hasTag("MMOITEMS_DURABILITY") ? nbt.getInteger("MMOITEMS_DURABILITY") : nbt.getInteger("MMOITEMS_MAX_DURABILITY"));
        }
        if (identifier.equals("durability_max")) {
            return "" + (int)MythicLib.plugin.getVersion().getWrapper().getNBTItem(player.getPlayer().getInventory().getItemInMainHand()).getDouble("MMOITEMS_MAX_DURABILITY");
        }
        if (identifier.equals("durability_ratio")) {
            NBTItem item = MythicLib.plugin.getVersion().getWrapper().getNBTItem(player.getPlayer().getInventory().getItemInMainHand());
            double durability = item.getDouble("MMOITEMS_DURABILITY");
            double maxDurability = item.getDouble("MMOITEMS_MAX_DURABILITY");
            return MythicLib.plugin.getMMOConfig().decimal.format(durability / maxDurability * 100.0);
        }
        if (identifier.equals("durability_bar_square")) {
            return this.getCurrentDurabilityBar(player.getPlayer().getInventory().getItemInMainHand(), "\u2588", 10);
        }
        if (identifier.equals("durability_bar_diamond")) {
            return this.getCurrentDurabilityBar(player.getPlayer().getInventory().getItemInMainHand(), "\u25c6", 15);
        }
        if (identifier.equals("durability_bar_thin")) {
            return this.getCurrentDurabilityBar(player.getPlayer().getInventory().getItemInMainHand(), "|", 20);
        }
        return null;
    }

    private String getCurrentDurabilityBar(ItemStack item, String barChar, int length) {
        NBTItem nbtItem = MythicLib.plugin.getVersion().getWrapper().getNBTItem(item);
        double durability = nbtItem.getDouble("MMOITEMS_DURABILITY");
        double maxDurability = nbtItem.getDouble("MMOITEMS_MAX_DURABILITY");
        long r = Math.round(durability / maxDurability * (double)length);
        StringBuilder bar = new StringBuilder("" + ChatColor.GREEN);
        for (int j = 0; j < length; ++j) {
            bar.append((long)j == r ? ChatColor.WHITE : "").append(barChar);
        }
        return bar.toString();
    }

    private boolean hasItem(Player player, EquipmentSlot slot) {
        return player.getInventory().getItem(slot) != null && player.getInventory().getItem(slot).getType() != Material.AIR;
    }
}

