/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.comp.mythicmobs.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.GenericCaster;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.auras.Aura;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.event.item.SpecialWeaponAttackEvent;
import net.Indyuce.mmoitems.api.interaction.weapon.untargeted.Lute;
import net.Indyuce.mmoitems.api.interaction.weapon.untargeted.Musket;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MMOItemsOnUseAura
extends Aura
implements ITargetedEntitySkill {
    @NotNull
    PlaceholderString skillName;
    @NotNull
    String weaponTypes;
    @Nullable
    Skill metaskill;
    boolean cancelEvent;
    boolean forceAsPower;
    @NotNull
    final ArrayList<UseItemTypes> auraWeapons = new ArrayList();

    public MMOItemsOnUseAura(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.skillName = mlc.getPlaceholderString(new String[]{"skill", "s", "ondamagedskill", "ondamaged", "od", "onhitskill", "onhit", "oh", "meta", "m", "mechanics", "$", "()"}, "skill not found", new String[0]);
        this.weaponTypes = mlc.getString(new String[]{"weapons", "weapon", "w"}, "MUSKET", new String[0]);
        this.metaskill = MMOItemsOnUseAura.GetSkill(this.skillName.get());
        this.cancelEvent = mlc.getBoolean(new String[]{"cancelevent", "ce"}, false);
        ArrayList<String> weaponTypesUnparsed = new ArrayList<String>();
        if (this.weaponTypes.contains(",")) {
            weaponTypesUnparsed.addAll(Arrays.asList(this.weaponTypes.split(",")));
        } else {
            weaponTypesUnparsed.add(this.weaponTypes);
        }
        for (String weapon : weaponTypesUnparsed) {
            try {
                UseItemTypes weap = UseItemTypes.valueOf(weapon.toUpperCase());
                this.auraWeapons.add(weap);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (this.metaskill == null) {
            new BukkitRunnable(){

                public void run() {
                    MMOItemsOnUseAura.this.metaskill = MMOItemsOnUseAura.GetSkill(MMOItemsOnUseAura.this.skillName.get());
                }
            }.runTaskLater((Plugin)MMOItems.plugin, 1L);
        }
    }

    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Object caster = MythicBukkit.inst().getMobManager().isActiveMob(target) ? MythicBukkit.inst().getMobManager().getMythicMobInstance(target) : new GenericCaster(target);
        new Tracker((SkillCaster)caster, data, target);
        return SkillResult.SUCCESS;
    }

    @Nullable
    public static Skill GetSkill(String skillName) {
        if (MMOItemsOnUseAura.SkillExists(skillName)) {
            Optional mSkillFk = MythicBukkit.inst().getSkillManager().getSkill(skillName);
            if (mSkillFk == null) {
                return null;
            }
            if (mSkillFk.isPresent()) {
                return (Skill)mSkillFk.get();
            }
        }
        return null;
    }

    public static boolean SkillExists(String skillName) {
        if (skillName == null) {
            return false;
        }
        Optional mSkillFk = MythicBukkit.inst().getSkillManager().getSkill(skillName);
        if (mSkillFk.isPresent()) {
            try {
                Skill mSkill = (Skill)mSkillFk.get();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    static enum UseItemTypes {
        LUTE(Lute.class),
        MUSKET(Musket.class);

        @NotNull
        final Class inst;

        @NotNull
        public Class getInst() {
            return this.inst;
        }

        private UseItemTypes(Class inst) {
            this.inst = inst;
        }
    }

    private class Tracker
    extends Aura.AuraTracker
    implements IParentSkill,
    Runnable {
        public Tracker(SkillCaster caster, SkillMetadata data, AbstractEntity entity) {
            super((Aura)MMOItemsOnUseAura.this, caster, entity, data);
            this.start();
        }

        public void auraStart() {
            this.registerAuraComponent((Terminable)Events.subscribe(SpecialWeaponAttackEvent.class).filter(event -> {
                if (!event.getPlayer().getUniqueId().equals(((AbstractEntity)this.entity.get()).getUniqueId())) {
                    return false;
                }
                if (MMOItemsOnUseAura.this.auraWeapons.size() == 0) {
                    return true;
                }
                for (UseItemTypes weap : MMOItemsOnUseAura.this.auraWeapons) {
                    if (!weap.getInst().isInstance(event.getWeapon())) continue;
                    return true;
                }
                return false;
            }).handler(event -> {
                SkillMetadata meta = this.skillMetadata.deepClone();
                if (MMOItemsOnUseAura.this.metaskill == null) {
                    MMOItemsOnUseAura.this.metaskill = MMOItemsOnUseAura.GetSkill(MMOItemsOnUseAura.this.skillName.get((PlaceholderMeta)meta, meta.getCaster().getEntity()));
                }
                AbstractEntity target = BukkitAdapter.adapt((Entity)event.getTarget());
                meta.setTrigger(target);
                if (this.executeAuraSkill(Optional.ofNullable(MMOItemsOnUseAura.this.metaskill), meta)) {
                    this.consumeCharge();
                    if (MMOItemsOnUseAura.this.cancelEvent) {
                        event.setCancelled(true);
                    }
                }
            }));
            this.executeAuraSkill(MMOItemsOnUseAura.this.onStartSkill, this.skillMetadata);
        }
    }
}

