/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.comp.mythicmobs.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.SkillAdapter;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.lib.api.crafting.uimanager.ProvidedUIFilter;
import io.lumine.mythic.lib.api.crafting.uimanager.UIFilterManager;
import java.io.File;
import java.util.ArrayList;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.listener.ItemUse;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MMOItemsArrowVolleyMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    @NotNull
    PlaceholderInt amount;
    @NotNull
    PlaceholderInt spread;
    @NotNull
    PlaceholderInt fireTicks;
    @NotNull
    PlaceholderInt removeDelay;
    @NotNull
    PlaceholderFloat velocity;
    @NotNull
    PlaceholderFloat scale;
    @NotNull
    PlaceholderDouble xOffset;
    @NotNull
    PlaceholderDouble yOffset;
    @NotNull
    PlaceholderDouble zOffset;
    @NotNull
    PlaceholderDouble fOffset;
    @NotNull
    PlaceholderDouble sOffset;
    @Nullable
    ItemStack arrowItem;
    boolean fullEvent;
    boolean scalePerArrow;
    boolean fromOrigin;
    boolean allowPickup;
    static boolean syncEventBlock;

    public MMOItemsArrowVolleyMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        ProvidedUIFilter uiFilter;
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "arrows", "a"}, 20, new String[0]);
        this.spread = mlc.getPlaceholderInteger(new String[]{"spread", "s"}, 45, new String[0]);
        this.fireTicks = mlc.getPlaceholderInteger(new String[]{"fireticks", "ft", "f"}, 0, new String[0]);
        this.removeDelay = mlc.getPlaceholderInteger(new String[]{"removedelay", "rd", "r"}, 200, new String[0]);
        this.velocity = mlc.getPlaceholderFloat(new String[]{"velocity", "v"}, 20.0f, new String[0]);
        this.scale = mlc.getPlaceholderFloat(new String[]{"statsscale", "ss"}, 1.0f, new String[0]);
        this.fullEvent = mlc.getBoolean(new String[]{"fullevent", "fe"}, false);
        this.scalePerArrow = mlc.getBoolean(new String[]{"scaleperarrow", "spa"}, false);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        this.allowPickup = mlc.getBoolean(new String[]{"allowpickup", "ap"}, false);
        String itemFilter = mlc.getString(new String[]{"arrowitem", "item", "ai"}, null, new String[0]);
        if (itemFilter != null && (uiFilter = UIFilterManager.getUIFilter((String)itemFilter.replace("<&sp>", " ").replace("\"", ""), null)) != null && uiFilter.isValid(null) && uiFilter.getParent().fullyDefinesItem()) {
            uiFilter.setAmount(Integer.valueOf(1));
            this.arrowItem = uiFilter.getItemStack(null);
        }
        this.xOffset = mlc.getPlaceholderDouble(new String[]{"startxoffset", "sxo"}, 0.0, new String[0]);
        this.yOffset = mlc.getPlaceholderDouble(new String[]{"startyoffset", "syo"}, 3.0, new String[0]);
        this.zOffset = mlc.getPlaceholderDouble(new String[]{"startzoffset", "szo"}, 0.0, new String[0]);
        this.fOffset = mlc.getPlaceholderDouble(new String[]{"startfoffset", "sfo"}, 0.0, new String[0]);
        this.sOffset = mlc.getPlaceholderDouble(new String[]{"startsoffset", "sso"}, 0.0, new String[0]);
    }

    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        if (data.getCaster().getEntity().getBukkitEntity() instanceof Player) {
            this.executeMIVolley(data.getCaster(), data, target, this.amount.get((PlaceholderMeta)data), this.velocity.get((PlaceholderMeta)data) * 0.1f, this.spread.get((PlaceholderMeta)data), this.fireTicks.get((PlaceholderMeta)data), this.removeDelay.get((PlaceholderMeta)data), this.scale);
        } else {
            SkillAdapter.get().executeVolley(data.getCaster(), target, this.amount.get((PlaceholderMeta)data), this.velocity.get((PlaceholderMeta)data) * 0.1f, (float)this.spread.get((PlaceholderMeta)data), this.fireTicks.get((PlaceholderMeta)data), this.removeDelay.get((PlaceholderMeta)data), this.allowPickup);
        }
        return SkillResult.SUCCESS;
    }

    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (data.getCaster().getEntity().getBukkitEntity() instanceof Player) {
            this.executeMIVolley(data.getCaster(), data, target.getLocation(), this.amount.get((PlaceholderMeta)data, target), this.velocity.get((PlaceholderMeta)data) * 0.1f, this.spread.get((PlaceholderMeta)data), this.fireTicks.get((PlaceholderMeta)data), this.removeDelay.get((PlaceholderMeta)data), this.scale);
        } else {
            SkillAdapter.get().executeVolley(data.getCaster(), target.getLocation(), this.amount.get((PlaceholderMeta)data, target), this.velocity.get((PlaceholderMeta)data) * 0.1f, (float)this.spread.get((PlaceholderMeta)data), this.fireTicks.get((PlaceholderMeta)data), this.removeDelay.get((PlaceholderMeta)data), this.allowPickup);
        }
        return SkillResult.SUCCESS;
    }

    public void executeMIVolley(@NotNull SkillCaster caster, @NotNull SkillMetadata data, @NotNull AbstractLocation t, int amount, float velocity, float spread, int fireTicks, int removeDelay, @NotNull PlaceholderFloat statsMultiplier) {
        if (syncEventBlock) {
            return;
        }
        if (!(caster.getEntity().getBukkitEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)caster.getEntity().getBukkitEntity();
        Location target = BukkitAdapter.adapt((AbstractLocation)t);
        Location spawn = BukkitAdapter.adapt((AbstractLocation)(this.fromOrigin ? data.getOrigin() : caster.getLocation())).clone();
        Vector forward = spawn.getDirection().normalize();
        Vector side = new Vector(-forward.getZ(), 1.0E-5, forward.getX()).normalize();
        double fS = this.fOffset.get((PlaceholderMeta)data);
        double sS = this.sOffset.get((PlaceholderMeta)data);
        spawn.setX(spawn.getX() + this.xOffset.get((PlaceholderMeta)data) + forward.getX() * fS + side.getX() * sS);
        spawn.setY(spawn.getY() + this.yOffset.get((PlaceholderMeta)data) + forward.getY() * fS + side.getY() * sS);
        spawn.setZ(spawn.getZ() + this.zOffset.get((PlaceholderMeta)data) + forward.getZ() * fS + side.getZ() * sS);
        Vector v = target.toVector().subtract(spawn.toVector()).normalize();
        ItemStack bowItem = player.getInventory().getItemInMainHand().clone();
        ItemStack localArrowItem = this.arrowItem != null ? this.arrowItem.clone() : new ItemStack(Material.ARROW);
        ItemUse use = new ItemUse();
        float arrowForce = statsMultiplier.get((PlaceholderMeta)data);
        ArrayList<Arrow> arrowList = new ArrayList<Arrow>();
        for (int i = 0; i < amount; ++i) {
            Arrow a = player.getWorld().spawnArrow(spawn, v, velocity, spread / 10.0f);
            a.setVelocity(a.getVelocity());
            if (this.allowPickup) {
                a.setPickupStatus(AbstractArrow.PickupStatus.ALLOWED);
            } else {
                a.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
            }
            a.setShooter((ProjectileSource)player);
            syncEventBlock = true;
            EntityShootBowEvent shootBowEvent = new EntityShootBowEvent((LivingEntity)player, bowItem, localArrowItem, (Entity)a, EquipmentSlot.HAND, arrowForce, false);
            if (this.fullEvent) {
                Bukkit.getPluginManager().callEvent((Event)shootBowEvent);
            } else {
                use.handleCustomBows(shootBowEvent);
            }
            syncEventBlock = false;
            if (shootBowEvent.isCancelled()) {
                a.remove();
                continue;
            }
            if (fireTicks > 0) {
                a.setFireTicks(fireTicks);
            }
            arrowList.add(a);
            if (!this.scalePerArrow) continue;
            arrowForce = statsMultiplier.get((PlaceholderMeta)data);
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MMOItems.plugin, () -> {
            for (Arrow a : arrowList) {
                a.remove();
            }
            arrowList.clear();
        }, (long)removeDelay);
    }
}

