/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.comp.mythicmobs;

import io.lumine.mythic.bukkit.events.MythicMobDeathEvent;
import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.version.VParticle;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ItemTier;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class LootsplosionListener
implements Listener {
    private static final Random RANDOM = new Random();
    private final boolean colored = MMOItems.plugin.getConfig().getBoolean("lootsplosion.color");

    @EventHandler(priority=EventPriority.HIGH)
    public void b(MythicMobDeathEvent event) {
        if (event.getMob().getVariables().has("Lootsplosion")) {
            new LootsplosionHandler(event);
        }
    }

    private Vector randomVector() {
        double offset = MMOItems.plugin.getConfig().getDouble("lootsplosion.offset");
        double height = MMOItems.plugin.getConfig().getDouble("lootsplosion.height");
        return new Vector(Math.cos(RANDOM.nextDouble() * Math.PI * 2.0) * offset, height, Math.sin(RANDOM.nextDouble() * Math.PI * 2.0) * offset);
    }

    public class LootsplosionHandler
    implements Listener {
        private final List<ItemStack> drops;
        private final double offset;

        public LootsplosionHandler(MythicMobDeathEvent event) {
            this.offset = event.getEntity().getHeight() / 2.0;
            this.drops = new ArrayList<ItemStack>(event.getDrops());
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)MMOItems.plugin);
        }

        private void close() {
            ItemSpawnEvent.getHandlerList().unregister((Listener)this);
        }

        @EventHandler
        public void a(ItemSpawnEvent event) {
            Item item = event.getEntity();
            if (!this.drops.contains(item.getItemStack())) {
                this.close();
                return;
            }
            this.drops.remove(item.getItemStack());
            item.teleport(item.getLocation().add(0.0, this.offset, 0.0));
            item.setVelocity(LootsplosionListener.this.randomVector());
            if (LootsplosionListener.this.colored) {
                Bukkit.getScheduler().runTask((Plugin)MMOItems.plugin, () -> {
                    ItemTier tier;
                    NBTItem nbt = MythicLib.plugin.getVersion().getWrapper().getNBTItem(item.getItemStack());
                    if (nbt.hasTag("MMOITEMS_TIER") && (tier = MMOItems.plugin.getTiers().get(nbt.getString("MMOITEMS_TIER"))).hasColor()) {
                        new LootColor(item, tier.getColor());
                    }
                });
            }
        }
    }

    public class LootColor
    extends BukkitRunnable {
        private final Item item;
        private final Color color;
        private int j = 0;

        public LootColor(Item item, ChatColor color) {
            this.item = item;
            this.color = MMOUtils.toRGB(color);
            this.runTaskTimer((Plugin)MMOItems.plugin, 0L, 1L);
        }

        public void run() {
            if (this.j++ > 100 || this.item.isDead() || this.item.isOnGround()) {
                this.cancel();
                return;
            }
            this.item.getWorld().spawnParticle(VParticle.REDSTONE.get(), this.item.getLocation(), 1, (Object)new Particle.DustOptions(this.color, 1.3f));
        }
    }
}

