/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.comp.mmocore.load;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.MMOLineConfig;
import io.lumine.mythic.lib.api.item.NBTItem;
import java.util.Optional;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.experience.dispenser.ExperienceDispenser;
import net.Indyuce.mmocore.experience.source.type.SpecificExperienceSource;
import net.Indyuce.mmocore.manager.profession.ExperienceSourceManager;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockCookEvent;
import org.bukkit.inventory.ItemStack;

public class SmeltMMOItemExperienceSource
extends SpecificExperienceSource<NBTItem> {
    private final String type;
    private final String id;

    public SmeltMMOItemExperienceSource(ExperienceDispenser dispenser, MMOLineConfig config) {
        super(dispenser, config);
        config.validate(new String[]{"type", "id"});
        this.type = config.getString("type").replace("-", "_").replace(" ", "_").toUpperCase();
        this.id = config.getString("id").replace("-", "_").replace(" ", "_").toUpperCase();
    }

    public ExperienceSourceManager<SmeltMMOItemExperienceSource> newManager() {
        return new ExperienceSourceManager<SmeltMMOItemExperienceSource>(){

            @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
            public void a(BlockCookEvent event) {
                Optional player = SmeltMMOItemExperienceSource.this.getNearbyPlayer(event.getBlock().getLocation());
                if (!player.isPresent()) {
                    return;
                }
                ItemStack caught = event.getResult();
                NBTItem nbt = MythicLib.plugin.getVersion().getWrapper().getNBTItem(caught);
                if (!nbt.hasType()) {
                    return;
                }
                PlayerData data = PlayerData.get((OfflinePlayer)((OfflinePlayer)player.get()));
                for (SmeltMMOItemExperienceSource source : this.getSources()) {
                    if (!source.matches(data, nbt)) continue;
                    source.giveExperience(data, 1.0, event.getBlock().getLocation().add(0.5, 1.0, 0.5));
                }
            }
        };
    }

    private Optional<Player> getNearbyPlayer(Location loc) {
        return loc.getWorld().getPlayers().stream().filter(player -> player.getLocation().distanceSquared(loc) < 100.0).findAny();
    }

    public boolean matchesParameter(PlayerData player, NBTItem obj) {
        return obj.getString("MMOITEMS_ITEM_TYPE").equals(this.type) && obj.getString("MMOITEMS_ITEM_ID").equals(this.id);
    }
}

