/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.comp.mmocore.load;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.MMOLineConfig;
import java.util.Optional;
import net.Indyuce.mmocore.loot.LootBuilder;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ItemTier;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.item.template.explorer.ClassFilter;
import net.Indyuce.mmoitems.api.item.template.explorer.TemplateExplorer;
import net.Indyuce.mmoitems.api.item.template.explorer.TierFilter;
import net.Indyuce.mmoitems.api.item.template.explorer.TypeFilter;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.player.RPGPlayer;
import net.Indyuce.mmoitems.comp.mmocore.load.ItemGenerationDropItem;
import net.Indyuce.mmoitems.stat.data.SoulboundData;
import org.apache.commons.lang.Validate;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;

public class RandomItemDropItem
extends ItemGenerationDropItem {
    private final boolean matchClass;
    private final String profess;
    private final Type type;
    private final ItemTier tier;

    public RandomItemDropItem(MMOLineConfig config) {
        super(config);
        String format;
        this.matchClass = config.getBoolean("match-class", false);
        this.profess = config.getString("class", "");
        if (config.contains("type")) {
            format = config.getString("type").toUpperCase().replace("-", "_").replace(" ", "_");
            Validate.isTrue((boolean)MMOItems.plugin.getTypes().has(format), (String)("Could not find item type with ID '" + format + "'"));
            this.type = MMOItems.plugin.getTypes().get(format);
        } else {
            this.type = null;
        }
        if (config.contains("tierset")) {
            format = UtilityMethods.enumName((String)config.getString("tierset"));
            Validate.isTrue((boolean)MMOItems.plugin.getTiers().has(format), (String)"Could not find item tier");
            this.tier = MMOItems.plugin.getTiers().get(format);
        } else {
            this.tier = null;
        }
    }

    public void collect(LootBuilder builder) {
        Optional<MMOItemTemplate> optional;
        RPGPlayer rpgPlayer = PlayerData.get((OfflinePlayer)builder.getEntity().getPlayer()).getRPG();
        TemplateExplorer explorer = new TemplateExplorer();
        if (this.matchClass) {
            explorer.applyFilter(new ClassFilter(rpgPlayer));
        } else if (!this.profess.isEmpty()) {
            explorer.applyFilter(new ClassFilter(this.profess));
        }
        if (this.type != null) {
            explorer.applyFilter(new TypeFilter(this.type));
        }
        if (this.tier != null) {
            explorer.applyFilter(new TierFilter(this.tier.getId()));
        }
        if (!(optional = explorer.rollLoot()).isPresent()) {
            return;
        }
        MMOItem rolled = this.rollMMOItem(optional.get(), rpgPlayer);
        if (this.rollSoulbound()) {
            rolled.setData(ItemStats.SOULBOUND, new SoulboundData(rpgPlayer.getPlayer(), 1));
        }
        ItemStack stack = this.rollUnidentification(rolled);
        stack.setAmount(this.rollAmount());
        builder.addLoot(stack);
    }
}

