/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.comp.mmocore.load;

import io.lumine.mythic.lib.api.MMOLineConfig;
import java.util.Objects;
import net.Indyuce.mmocore.api.block.BlockInfo;
import net.Indyuce.mmocore.api.block.BlockType;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.block.CustomBlock;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;

public class MMOItemsBlockType
implements BlockType {
    private final int id;

    public MMOItemsBlockType(MMOLineConfig config) {
        config.validate(new String[]{"id"});
        this.id = config.getInt("id");
    }

    public MMOItemsBlockType(CustomBlock block) {
        this.id = block.getId();
    }

    public int getBlockId() {
        return this.id;
    }

    public static boolean matches(Block block) {
        return MMOItems.plugin.getCustomBlocks().isMushroomBlock(block.getType());
    }

    @NotNull
    public String display() {
        return "MMOItems{" + this.id + "}";
    }

    public void place(BlockInfo.RegeneratingBlock regeneratingBlock) {
        Location loc = regeneratingBlock.getLocation();
        CustomBlock block = MMOItems.plugin.getCustomBlocks().getBlock(this.id);
        loc.getBlock().setType(block.getState().getType());
        loc.getBlock().setBlockData(block.getState().getBlockData());
    }

    public void regenerate(BlockInfo.RegeneratingBlock regeneratingBlock) {
        this.place(regeneratingBlock);
    }

    public boolean breakRestrictions(Block block) {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MMOItemsBlockType that = (MMOItemsBlockType)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

