/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.comp.mmocore.load;

import io.lumine.mythic.lib.api.MMOLineConfig;
import io.lumine.mythic.lib.api.util.SmartGive;
import net.Indyuce.mmocore.api.quest.trigger.Trigger;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.player.PlayerData;
import org.apache.commons.lang.Validate;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;

public class MMOItemTrigger
extends Trigger {
    private final MMOItemTemplate template;
    private final int amount;

    public MMOItemTrigger(MMOLineConfig config) {
        super(config);
        config.validate(new String[]{"type", "id"});
        String format = config.getString("type").toUpperCase().replace("-", "_").replace(" ", "_");
        Validate.isTrue((boolean)MMOItems.plugin.getTypes().has(format), (String)("Could not find item type with ID '" + format + "'"));
        Type type = MMOItems.plugin.getTypes().get(format);
        String id = config.getString("id").replace("-", "_").toUpperCase();
        Validate.isTrue((boolean)MMOItems.plugin.getTemplates().hasTemplate(type, id), (String)("Could not find MMOItem with ID '" + id + "'"));
        this.template = MMOItems.plugin.getTemplates().getTemplate(type, id);
        this.amount = Math.max(1, config.getInt("amount", 1));
    }

    public void apply(net.Indyuce.mmocore.api.player.PlayerData player) {
        ItemStack item = this.template.newBuilder(PlayerData.get((OfflinePlayer)player.getPlayer()).getRPG()).build().newBuilder().build();
        item.setAmount(this.amount);
        new SmartGive(player.getPlayer()).give(new ItemStack[]{item});
    }
}

