/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.comp.mmocore.crafting;

import io.lumine.mythic.lib.api.MMOLineConfig;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.experience.EXPSource;
import net.Indyuce.mmocore.experience.Profession;
import net.Indyuce.mmoitems.api.crafting.trigger.Trigger;
import net.Indyuce.mmoitems.api.player.PlayerData;
import org.apache.commons.lang.Validate;
import org.bukkit.OfflinePlayer;

public class ExperienceCraftingTrigger
extends Trigger {
    private final Profession profession;
    private final int amount;

    public ExperienceCraftingTrigger(MMOLineConfig config) {
        super("exp");
        config.validate(new String[]{"profession", "amount"});
        this.amount = config.getInt("amount");
        String id = config.getString("profession").toLowerCase().replace("_", "-");
        if (!id.equalsIgnoreCase("main")) {
            Validate.isTrue((boolean)MMOCore.plugin.professionManager.has(id), (String)("Could not find profession " + id));
            this.profession = MMOCore.plugin.professionManager.get(id);
        } else {
            this.profession = null;
        }
    }

    @Override
    public void whenCrafting(PlayerData data) {
        if (this.profession == null) {
            net.Indyuce.mmocore.api.player.PlayerData.get((OfflinePlayer)data.getPlayer()).giveExperience((double)this.amount, EXPSource.SOURCE);
        } else {
            net.Indyuce.mmocore.api.player.PlayerData.get((OfflinePlayer)data.getPlayer()).getCollectionSkills().giveExperience(this.profession, (double)this.amount, EXPSource.SOURCE);
        }
    }
}

