/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.comp.enchants.advanced_enchants;

import io.lumine.mythic.lib.api.item.ItemTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.comp.enchants.advanced_enchants.AdvancedEnchantMap;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.random.RandomStatData;
import net.Indyuce.mmoitems.stat.type.InternalStat;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.advancedplugins.ae.api.AEAPI;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedEnchantsStat
extends ItemStat<RandomStatData<AdvancedEnchantMap>, AdvancedEnchantMap>
implements InternalStat {
    private final Plugin ae = Bukkit.getPluginManager().getPlugin("AdvancedEnchantments");
    private final String aeNamespace;
    private static final String AE_KEY_PREFIX = "ae_enchantment-";
    private static final String LEGACY_AE_KEY_PREFIX = "ae_enchantment;";

    public AdvancedEnchantsStat() {
        super("ADVANCED_ENCHANTS", Material.EXPERIENCE_BOTTLE, "Advanced Enchants", new String[]{"The AEnchants of this item. Format:", "\u00a7e[internal_name] [level]"}, new String[]{"!miscellaneous", "!block", "all"}, new Material[0]);
        Validate.notNull((Object)this.ae, (String)"Could not find plugin AdvancedEnchants");
        this.aeNamespace = new NamespacedKey(this.ae, "any").getNamespace();
    }

    @Override
    public RandomStatData<AdvancedEnchantMap> whenInitialized(Object object) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull AdvancedEnchantMap data) {
        data.enchants.forEach((ench, lvl) -> {
            if (ench == null || lvl == null || ench.isEmpty()) {
                return;
            }
            item.getLore().insert(0, AEAPI.getEnchantLore((String)ench, (int)lvl));
            item.getMeta().getPersistentDataContainer().set(new NamespacedKey(this.ae, AE_KEY_PREFIX + ench), PersistentDataType.INTEGER, lvl);
        });
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull AdvancedEnchantMap data) {
        return new ArrayList<ItemTag>();
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<RandomStatData<AdvancedEnchantMap>> statData) {
    }

    @Override
    @NotNull
    public AdvancedEnchantMap getClearStatData() {
        return new AdvancedEnchantMap();
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        ItemMeta meta = mmoitem.getNBT().getItem().getItemMeta();
        if (meta == null) {
            return;
        }
        AdvancedEnchantMap enchants = new AdvancedEnchantMap();
        for (String tag : mmoitem.getNBT().getTags()) {
            if (tag == null || !tag.startsWith(LEGACY_AE_KEY_PREFIX)) continue;
            String enchantTag = tag.substring(LEGACY_AE_KEY_PREFIX.length());
            int lvl = mmoitem.getNBT().getInteger(tag);
            enchants.enchants.put(enchantTag, lvl);
        }
        for (NamespacedKey nsk : meta.getPersistentDataContainer().getKeys()) {
            Integer lvlInteger;
            String tag;
            if (!nsk.getNamespace().equals(this.aeNamespace) || !(tag = nsk.getKey()).startsWith(AE_KEY_PREFIX) || (lvlInteger = (Integer)meta.getPersistentDataContainer().get(nsk, PersistentDataType.INTEGER)) == null || lvlInteger == 0) continue;
            String enchantTag = tag.substring(AE_KEY_PREFIX.length());
            enchants.enchants.put(enchantTag, lvlInteger);
        }
        if (!enchants.enchants.isEmpty()) {
            mmoitem.setData(this, enchants);
        }
    }

    @Override
    @Nullable
    public AdvancedEnchantMap getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        return null;
    }
}

