/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.comp.eco;

import io.lumine.mythic.lib.api.MMOLineConfig;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.crafting.condition.Condition;
import net.Indyuce.mmoitems.api.player.PlayerData;
import org.apache.commons.lang.Validate;
import org.bukkit.OfflinePlayer;

public class MoneyCondition
extends Condition {
    private final double amount;

    public MoneyCondition(MMOLineConfig config) {
        super("money");
        Validate.isTrue((boolean)MMOItems.plugin.hasEconomy(), (String)"No economy plugin found");
        config.validateKeys(new String[]{"amount"});
        this.amount = config.getDouble("amount");
    }

    @Override
    public boolean isMet(PlayerData data) {
        return MMOItems.plugin.getVault().getEconomy().has((OfflinePlayer)data.getPlayer(), this.amount);
    }

    @Override
    public String formatDisplay(String string) {
        return string.replace("#money#", String.valueOf(this.amount));
    }

    @Override
    public void whenCrafting(PlayerData data) {
        MMOItems.plugin.getVault().getEconomy().withdrawPlayer((OfflinePlayer)data.getPlayer(), this.amount);
    }

    public double getAmount() {
        return this.amount;
    }
}

