/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.comp;

import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.internal.registry.InputParser;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.block.CustomBlock;
import net.Indyuce.mmoitems.api.util.MushroomState;

public class WorldEditSupport {
    public WorldEditSupport() {
        WorldEdit.getInstance().getBlockFactory().register((InputParser)new WECustomBlockInputParser());
    }

    public class WECustomBlockInputParser
    extends InputParser<BaseBlock> {
        public WECustomBlockInputParser() {
            super(WorldEdit.getInstance());
        }

        public BaseBlock parseFromInput(String input, ParserContext context) {
            BlockType type;
            int id;
            if (!(input = input.toLowerCase()).startsWith("mmoitems-")) {
                return null;
            }
            try {
                id = Integer.parseInt(input.split("-")[1]);
            }
            catch (NumberFormatException e) {
                return null;
            }
            CustomBlock block = MMOItems.plugin.getCustomBlocks().getBlock(id);
            if (block == null) {
                return null;
            }
            MushroomState mush = block.getState();
            switch (mush.getType()) {
                case MUSHROOM_STEM: {
                    type = BlockTypes.MUSHROOM_STEM;
                    break;
                }
                case BROWN_MUSHROOM_BLOCK: {
                    type = BlockTypes.BROWN_MUSHROOM_BLOCK;
                    break;
                }
                case RED_MUSHROOM_BLOCK: {
                    type = BlockTypes.RED_MUSHROOM_BLOCK;
                    break;
                }
                default: {
                    return null;
                }
            }
            BlockState state = type.getDefaultState().with((Property)type.getPropertyMap().get("up"), (Object)mush.getSide("up")).with((Property)type.getPropertyMap().get("down"), (Object)mush.getSide("down")).with((Property)type.getPropertyMap().get("north"), (Object)mush.getSide("north")).with((Property)type.getPropertyMap().get("south"), (Object)mush.getSide("south")).with((Property)type.getPropertyMap().get("east"), (Object)mush.getSide("east")).with((Property)type.getPropertyMap().get("west"), (Object)mush.getSide("west"));
            return state.toBaseBlock();
        }
    }
}

