/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.command.mmoitems.revid;

import io.lumine.mythic.lib.command.api.CommandTreeNode;
import java.util.ArrayList;
import java.util.function.Function;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ConfigFile;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.command.mmoitems.revid.RevisionIDCommandTreeNode;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class RevIDActionCommandTreeNode
extends CommandTreeNode {
    private final String cmdType;
    private final Function<Integer, Integer> modifier;

    public RevIDActionCommandTreeNode(CommandTreeNode parent, String type, Function<Integer, Integer> modifier) {
        super(parent, type);
        this.cmdType = type;
        this.modifier = modifier;
        this.addParameter(RevisionIDCommandTreeNode.TYPE_OR_ALL);
    }

    public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
        if (args.length < 3) {
            return CommandTreeNode.CommandResult.THROW_USAGE;
        }
        if (!Type.isValid(args[2]) && !args[2].equalsIgnoreCase("all")) {
            sender.sendMessage(MMOItems.plugin.getPrefix() + ChatColor.RED + "There is no item type called " + args[2].toUpperCase().replace("-", "_") + ".");
            sender.sendMessage(MMOItems.plugin.getPrefix() + ChatColor.RED + "Type " + ChatColor.GREEN + "/mi list type" + ChatColor.RED + " to see all the available item types.");
            return CommandTreeNode.CommandResult.FAILURE;
        }
        Type type = args[2].equalsIgnoreCase("all") ? null : Type.get(args[2]);
        ArrayList<MMOItemTemplate> templates = new ArrayList<MMOItemTemplate>(type == null ? MMOItems.plugin.getTemplates().collectTemplates() : MMOItems.plugin.getTemplates().getTemplates(type));
        int failed = 0;
        for (MMOItemTemplate template : templates) {
            ConfigFile file = template.getType().getConfigFile();
            if (!file.getConfig().isConfigurationSection(template.getId() + ".base")) {
                ++failed;
                continue;
            }
            file.getConfig().getConfigurationSection(template.getId() + ".base").set("revision-id", (Object)this.modifier.apply(template.getRevisionId()));
            file.registerTemplateEdition(template);
        }
        if (failed > 0) {
            sender.sendMessage(MMOItems.plugin.getPrefix() + ChatColor.RED + "Couldn't find ConfigurationSection for " + failed + " of the specified items.");
        } else {
            sender.sendMessage(MMOItems.plugin.getPrefix() + ChatColor.GREEN + "Successfully " + this.cmdType + "d Rev IDs" + (type != null ? " for " + type.getName() : "") + "!");
        }
        return CommandTreeNode.CommandResult.SUCCESS;
    }
}

