/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.world;

import java.util.Map;
import java.util.Random;
import net.Indyuce.mmoitems.api.block.CustomBlock;
import net.Indyuce.mmoitems.api.block.WorldGenTemplate;
import net.Indyuce.mmoitems.manager.WorldGenManager;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.jetbrains.annotations.NotNull;

public class MMOBlockPopulator
extends BlockPopulator {
    private static final BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.WEST, BlockFace.EAST, BlockFace.DOWN, BlockFace.UP};
    private final WorldGenManager manager;
    private final World world;

    public MMOBlockPopulator(World world, WorldGenManager manager) {
        this.manager = manager;
        this.world = world;
    }

    public void populate(@NotNull WorldInfo worldInfo, @NotNull Random random, int chunkX, int chunkZ, @NotNull LimitedRegion limitedRegion) {
        Map<CustomBlock, WorldGenTemplate> assigned = this.manager.assigned();
        assigned.entrySet().stream().filter(entry -> ((WorldGenTemplate)entry.getValue()).canGenerateInWorld(worldInfo.getName())).filter(entry -> ((WorldGenTemplate)entry.getValue()).getMinDepth() >= worldInfo.getMinHeight()).filter(entry -> ((WorldGenTemplate)entry.getValue()).getMaxDepth() <= worldInfo.getMaxHeight()).forEach(entry -> {
            CustomBlock block = (CustomBlock)entry.getKey();
            WorldGenTemplate template = (WorldGenTemplate)entry.getValue();
            if (random.nextDouble() > template.getChunkChance()) {
                return;
            }
            for (int i = 0; i < template.getVeinCount(); ++i) {
                int z;
                int y;
                int x = chunkX * 16 + random.nextInt(16);
                Location generatePoint = new Location(this.world, (double)x, (double)(y = random.nextInt(template.getMaxDepth() - template.getMinDepth() + 1) + template.getMinDepth()), (double)(z = chunkZ * 16 + random.nextInt(16)));
                if (!template.canGenerate(generatePoint) || generatePoint.getWorld() == null) continue;
                Block modify = generatePoint.getWorld().getBlockAt(generatePoint);
                for (int j = 0; j < template.getVeinSize(); ++j) {
                    if (!limitedRegion.isInRegion(modify.getLocation())) continue;
                    if (template.canReplace(limitedRegion.getType(modify.getLocation()))) {
                        limitedRegion.setType(modify.getLocation(), block.getState().getType());
                        limitedRegion.setBlockData(modify.getLocation(), block.getState().getBlockData());
                    }
                    BlockFace nextFace = faces[random.nextInt(faces.length)];
                    modify = modify.getRelative(nextFace);
                }
            }
        });
    }
}

