/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.util;

import io.lumine.mythic.lib.version.Sounds;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoundReader {
    @Nullable
    private final Sound sound;
    @Nullable
    private final String soundKey;

    public SoundReader(@NotNull String tag, @NotNull Sound defaultSound) {
        String soundKey;
        Sound sound;
        if (tag.isEmpty()) {
            this.sound = defaultSound;
            this.soundKey = "";
            return;
        }
        try {
            sound = Sounds.fromName((String[])new String[]{tag});
            soundKey = null;
        }
        catch (Exception exception) {
            sound = null;
            soundKey = tag.toLowerCase();
        }
        this.sound = sound;
        this.soundKey = soundKey;
    }

    @Nullable
    public Sound getSound() {
        return this.sound;
    }

    @NotNull
    public String getSoundKey() {
        return this.soundKey;
    }

    public void play(@NotNull Player player) {
        this.play(player, 1.0f, 1.0f);
    }

    public void play(@NotNull Player player, float vol, float pitch) {
        if (this.sound != null) {
            player.playSound(player.getLocation(), this.sound, vol, pitch);
        } else {
            player.playSound(player.getLocation(), this.soundKey, vol, pitch);
        }
    }

    public void play(@NotNull Location loc) {
        this.play(loc, 1.0f, 1.0f);
    }

    public void play(@NotNull Location loc, float vol, float pitch) {
        if (this.sound != null) {
            loc.getWorld().playSound(loc, this.sound, vol, pitch);
        } else {
            loc.getWorld().playSound(loc, this.soundKey, vol, pitch);
        }
    }
}

