/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.util;

import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import java.util.Objects;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ItemTier;
import net.Indyuce.mmoitems.api.ReforgeOptions;
import net.Indyuce.mmoitems.api.event.MMOItemReforgeEvent;
import net.Indyuce.mmoitems.api.event.MMOItemReforgeFinishEvent;
import net.Indyuce.mmoitems.api.item.mmoitem.LiveMMOItem;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.player.RPGPlayer;
import net.Indyuce.mmoitems.stat.data.DoubleData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.stat.type.StatHistory;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MMOItemReforger {
    @NotNull
    private final NBTItem nbtItem;
    @Nullable
    private ItemStack result;
    @Nullable
    private RPGPlayer player;
    @Nullable
    LiveMMOItem oldMMOItem;
    @Nullable
    private final MMOItemTemplate template;
    @Nullable
    private MMOItem freshMMOItem;
    @NotNull
    final ArrayList<ItemStack> reforgingOutput = new ArrayList();
    int generationItemLevel;
    public static boolean keepTiersWhenReroll = true;
    public static boolean gemstonesRevIDWhenUnsocket = false;

    public MMOItemReforger(@NotNull ItemStack stack) {
        this(NBTItem.get((ItemStack)stack));
    }

    public MMOItemReforger(@NotNull NBTItem nbtItem) {
        this.nbtItem = nbtItem;
        Validate.isTrue((nbtItem.getItem().getItemMeta() != null ? 1 : 0) != 0, (String)"ItemStack has no ItemMeta, cannot be reforged.");
        this.template = nbtItem.hasType() ? MMOItems.plugin.getTemplates().getTemplate(nbtItem) : null;
    }

    @NotNull
    public NBTItem getNBTItem() {
        return this.nbtItem;
    }

    @NotNull
    public ItemStack getStack() {
        return this.nbtItem.getItem();
    }

    @Nullable
    public ItemStack getResult() {
        return this.result;
    }

    public void setResult(@Nullable ItemStack item) {
        this.result = item;
    }

    @Deprecated
    @NotNull
    public ItemMeta getMeta() {
        return this.getStack().getItemMeta();
    }

    @Nullable
    public RPGPlayer getPlayer() {
        return this.player;
    }

    @Deprecated
    public void setPlayer(@Nullable Player player) {
        this.setPlayer(player == null ? null : PlayerData.get((OfflinePlayer)player).getRPG());
    }

    @Deprecated
    public void setPlayer(@Nullable RPGPlayer player) {
        this.player = player;
    }

    @NotNull
    public LiveMMOItem getOldMMOItem() {
        return this.oldMMOItem;
    }

    @NotNull
    public MMOItemTemplate getTemplate() {
        return Objects.requireNonNull(this.template, "No item template was found");
    }

    @NotNull
    public MMOItem getFreshMMOItem() {
        return this.freshMMOItem;
    }

    public void setFreshMMOItem(@NotNull MMOItem mmo) {
        this.freshMMOItem = mmo;
    }

    @Deprecated
    public boolean canReforge() {
        return this.hasTemplate();
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public void addReforgingOutput(@Nullable ItemStack item) {
        if (!SilentNumbers.isAir((ItemStack)item) && item.getType().isItem()) {
            this.reforgingOutput.add(item);
        }
    }

    public void clearReforgingOutput() {
        this.reforgingOutput.clear();
    }

    @NotNull
    public ArrayList<ItemStack> getReforgingOutput() {
        return this.reforgingOutput;
    }

    public int getGenerationItemLevel() {
        return this.generationItemLevel;
    }

    public boolean reforge(@NotNull ReforgeOptions options) {
        return this.reforge(options, (RPGPlayer)null);
    }

    public boolean reforge(@NotNull ReforgeOptions options, @Nullable Player player) {
        return this.reforge(options, player == null ? null : PlayerData.get((OfflinePlayer)player).getRPG());
    }

    public boolean reforge(@NotNull ReforgeOptions options, @Nullable RPGPlayer player) {
        if (!this.hasTemplate()) {
            return false;
        }
        this.oldMMOItem = new LiveMMOItem(this.getNBTItem());
        if (options.isBlacklisted(this.getOldMMOItem().getId())) {
            return false;
        }
        this.player = player;
        this.generationItemLevel = this.getOldMMOItem().hasData(ItemStats.ITEM_LEVEL) ? (int)((DoubleData)this.getOldMMOItem().getData(ItemStats.ITEM_LEVEL)).getValue() : 0;
        ItemTier tier = options.shouldKeepTier() && this.getOldMMOItem().hasData(ItemStats.TIER) ? MMOItems.plugin.getTiers().get(this.getOldMMOItem().getData(ItemStats.TIER).toString()) : null;
        this.setFreshMMOItem(this.getTemplate().newBuilder(this.generationItemLevel, tier).build());
        MMOItemReforgeEvent mmoREV = new MMOItemReforgeEvent(this, options);
        Bukkit.getPluginManager().callEvent((Event)mmoREV);
        if (mmoREV.isCancelled()) {
            return false;
        }
        for (StatHistory hist : this.getFreshMMOItem().getStatHistories()) {
            this.getFreshMMOItem().setData(hist.getItemStat(), hist.recalculate(this.getFreshMMOItem().getUpgradeLevel()));
        }
        if (this.getFreshMMOItem().hasUpgradeTemplate()) {
            for (ItemStat stat : this.getFreshMMOItem().getUpgradeTemplate().getKeys()) {
                StatHistory hist = this.getFreshMMOItem().computeStatHistory(stat);
                this.getFreshMMOItem().setData(hist.getItemStat(), hist.recalculate(this.getFreshMMOItem().getUpgradeLevel()));
            }
        }
        this.result = this.getFreshMMOItem().newBuilder().build();
        MMOItemReforgeFinishEvent mmoFIN = new MMOItemReforgeFinishEvent(this.result, this, options);
        Bukkit.getPluginManager().callEvent((Event)mmoFIN);
        this.setResult(mmoFIN.getFinishedItem());
        return !mmoFIN.isCancelled();
    }

    public static void reload() {
        keepTiersWhenReroll = MMOItems.plugin.getConfig().getBoolean("item-revision.keep-tiers");
        gemstonesRevIDWhenUnsocket = MMOItems.plugin.getConfig().getBoolean("item-revision.regenerate-gems-when-unsocketed", false);
    }

    @Deprecated
    public MMOItemReforger(@Nullable ItemStack stack, @NotNull NBTItem nbtItem) {
        this(nbtItem);
    }

    @Deprecated
    public void update(@Nullable Player p, @NotNull ReforgeOptions options) {
        this.reforge(options, p);
    }

    @Deprecated
    public void update(@Nullable RPGPlayer player, @NotNull ReforgeOptions options) {
        this.reforge(options, player);
    }

    @Deprecated
    void regenerate(@Nullable RPGPlayer p) {
        this.reforge(new ReforgeOptions(), p);
    }

    @Deprecated
    int regenerate(@Nullable RPGPlayer player, @NotNull MMOItemTemplate template) {
        this.reforge(new ReforgeOptions(), player);
        return 0;
    }

    @Deprecated
    public void reforge(@Nullable Player p, @NotNull ReforgeOptions options) {
        this.reforge(options, p);
    }

    @Deprecated
    public void reforge(@Nullable RPGPlayer player, @NotNull ReforgeOptions options) {
        this.reforge(options, player);
    }

    @Deprecated
    public ItemStack toStack() {
        return this.getResult();
    }

    @Deprecated
    public boolean hasChanges() {
        return this.getResult() != null;
    }

    @Deprecated
    @NotNull
    public ArrayList<MMOItem> getDestroyedGems() {
        return new ArrayList<MMOItem>();
    }
}

