/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.player;

import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.stat.StatInstance;
import io.lumine.mythic.lib.api.stat.StatMap;
import io.lumine.mythic.lib.api.stat.modifier.StatModifier;
import io.lumine.mythic.lib.player.PlayerMetadata;
import io.lumine.mythic.lib.player.modifier.ModifierSource;
import io.lumine.mythic.lib.player.modifier.ModifierType;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.player.inventory.EquippedItem;
import net.Indyuce.mmoitems.stat.type.AttackWeaponStat;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import org.jetbrains.annotations.NotNull;

public class PlayerStats {
    private final PlayerData playerData;

    public PlayerStats(PlayerData playerData) {
        this.playerData = playerData;
    }

    public PlayerData getData() {
        return this.playerData;
    }

    @NotNull
    public StatMap getMap() {
        return this.playerData.getMMOPlayerData().getStatMap();
    }

    public double getStat(@NotNull ItemStat<?, ?> stat) {
        return this.getMap().getStat(stat.getId());
    }

    @NotNull
    public StatInstance getInstance(@NotNull ItemStat<?, ?> stat) {
        return this.getMap().getInstance(stat.getId());
    }

    @NotNull
    public PlayerMetadata newTemporary(@NotNull EquipmentSlot castSlot) {
        return this.playerData.getMMOPlayerData().getStatMap().cache(castSlot);
    }

    public void updateStats() {
        for (ItemStat itemStat : MMOItems.plugin.getStats().getNumericStats()) {
            StatInstance.ModifierPacket packet = this.getInstance(itemStat).newPacket();
            packet.removeIf(name -> name.startsWith("MMOItem"));
            if (this.playerData.hasSetBonuses() && this.playerData.getSetBonuses().hasStat(itemStat)) {
                packet.addModifier(new StatModifier("MMOItemSetBonus", itemStat.getId(), this.playerData.getSetBonuses().getStat(itemStat), ModifierType.FLAT, EquipmentSlot.OTHER, ModifierSource.OTHER));
            }
            int index = 0;
            for (EquippedItem item : this.playerData.getInventory().getEquipped()) {
                double value = item.getNBT().getStat(itemStat.getId());
                if (value == 0.0) continue;
                ModifierSource source = item.getCached().getType().getModifierSource();
                if (source.isWeapon() && itemStat instanceof AttackWeaponStat) {
                    value -= ((AttackWeaponStat)itemStat).getOffset(this.playerData);
                }
                packet.addModifier(new StatModifier("MMOItem-" + index++, itemStat.getId(), value, ModifierType.FLAT, item.getSlot(), source));
            }
            packet.update();
        }
    }
}

