/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.player;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.damage.AttackMetadata;
import io.lumine.mythic.lib.data.SynchronizedDataHolder;
import io.lumine.mythic.lib.player.PlayerMetadata;
import io.lumine.mythic.lib.player.cooldown.CooldownObject;
import io.lumine.mythic.lib.player.modifier.ModifierSource;
import io.lumine.mythic.lib.player.modifier.PlayerModifier;
import io.lumine.mythic.lib.player.skill.PassiveSkill;
import io.lumine.mythic.lib.skill.Skill;
import io.lumine.mythic.lib.skill.trigger.TriggerMetadata;
import io.lumine.mythic.lib.util.Closeable;
import io.lumine.mythic.lib.util.MMOPlugin;
import io.lumine.mythic.lib.version.VPotionEffectType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ItemSet;
import net.Indyuce.mmoitems.api.crafting.CraftingStatus;
import net.Indyuce.mmoitems.api.event.RefreshInventoryEvent;
import net.Indyuce.mmoitems.api.item.ItemReference;
import net.Indyuce.mmoitems.api.item.mmoitem.VolatileMMOItem;
import net.Indyuce.mmoitems.api.player.PlayerStats;
import net.Indyuce.mmoitems.api.player.RPGPlayer;
import net.Indyuce.mmoitems.api.player.inventory.EquippedItem;
import net.Indyuce.mmoitems.api.player.inventory.InventoryUpdateHandler;
import net.Indyuce.mmoitems.particle.api.ParticleRunnable;
import net.Indyuce.mmoitems.stat.data.AbilityData;
import net.Indyuce.mmoitems.stat.data.AbilityListData;
import net.Indyuce.mmoitems.stat.data.ParticleData;
import net.Indyuce.mmoitems.stat.data.PotionEffectListData;
import net.Indyuce.mmoitems.stat.data.StringListData;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerData
extends SynchronizedDataHolder
implements Closeable {
    private RPGPlayer rpgPlayer;
    private final InventoryUpdateHandler inventory = new InventoryUpdateHandler(this);
    private final CraftingStatus craftingStatus = new CraftingStatus();
    private final Map<PotionEffectType, PotionEffect> permanentEffects = new HashMap<PotionEffectType, PotionEffect>();
    private final Set<ParticleRunnable> itemParticles = new HashSet<ParticleRunnable>();
    private ParticleRunnable overridingItemParticles = null;
    private boolean encumbered = false;
    @Nullable
    private ItemSet.SetBonuses setBonuses = null;
    private final PlayerStats stats;
    private final Set<String> permissions = new HashSet<String>();

    public PlayerData(@NotNull MMOPlayerData mmoData) {
        super((MMOPlugin)MMOItems.plugin, mmoData);
        this.rpgPlayer = MMOItems.plugin.getMainRPG().getInfo(this);
        this.stats = new PlayerStats(this);
    }

    public void close() {
        this.cancelRunnables();
    }

    public boolean isOnline() {
        return this.getMMOPlayerData().isOnline();
    }

    public RPGPlayer getRPG() {
        return this.rpgPlayer;
    }

    public void cancelRunnables() {
        this.itemParticles.forEach(BukkitRunnable::cancel);
        if (this.overridingItemParticles != null) {
            this.overridingItemParticles.cancel();
        }
    }

    @Deprecated
    public boolean areHandsFull() {
        return this.isEncumbered();
    }

    public boolean isEncumbered() {
        NBTItem main = MythicLib.plugin.getVersion().getWrapper().getNBTItem(this.getPlayer().getInventory().getItemInMainHand());
        NBTItem off = MythicLib.plugin.getVersion().getWrapper().getNBTItem(this.getPlayer().getInventory().getItemInOffHand());
        boolean mainhand_twohanded = main.getBoolean(ItemStats.TWO_HANDED.getNBTPath());
        boolean offhand_twohanded = off.getBoolean(ItemStats.TWO_HANDED.getNBTPath());
        boolean mainhand_encumbering = main.getItem() != null && main.getItem().getType() != Material.AIR && !main.getBoolean(ItemStats.HANDWORN.getNBTPath());
        boolean offhand_encumbering = off.getItem() != null && off.getItem().getType() != Material.AIR && !off.getBoolean(ItemStats.HANDWORN.getNBTPath());
        return mainhand_twohanded && offhand_encumbering || mainhand_encumbering && offhand_twohanded;
    }

    public void setRPGPlayer(RPGPlayer rpgPlayer) {
        this.rpgPlayer = rpgPlayer;
    }

    public void updateInventory() {
        if (!this.isOnline() || !this.getMMOPlayerData().hasFullySynchronized()) {
            return;
        }
        this.inventory.getEquipped().clear();
        this.permanentEffects.clear();
        this.cancelRunnables();
        this.getMMOPlayerData().getPassiveSkillMap().removeModifiers("MMOItemsItem");
        this.itemParticles.clear();
        this.overridingItemParticles = null;
        if (MMOItems.plugin.hasPermissions()) {
            Permission perms = MMOItems.plugin.getVault().getPermissions();
            this.permissions.forEach(perm -> {
                if (perms.has(this.getPlayer(), perm)) {
                    perms.playerRemove(this.getPlayer(), perm);
                }
            });
        }
        this.permissions.clear();
        this.encumbered = this.isEncumbered();
        for (EquippedItem equippedItem : MMOItems.plugin.getInventory().getInventory(this.getPlayer())) {
            NBTItem nBTItem = equippedItem.getNBT();
            if (nBTItem.getItem() == null || nBTItem.getItem().getType() == Material.AIR || !equippedItem.isPlacementLegal() || !this.getRPG().canUse(nBTItem, false, false)) continue;
            this.inventory.getEquipped().add(equippedItem);
        }
        Bukkit.getPluginManager().callEvent((Event)new RefreshInventoryEvent(this.inventory.getEquipped(), this.getPlayer(), this));
        for (EquippedItem equippedItem : this.inventory.getEquipped()) {
            EquipmentSlot equipmentSlot;
            VolatileMMOItem volatileMMOItem = equippedItem.getCached();
            ModifierSource source = volatileMMOItem.getType().getModifierSource();
            if (!EquipmentSlot.MAIN_HAND.isCompatible(source, equipmentSlot = equippedItem.getSlot())) continue;
            if (volatileMMOItem.hasData(ItemStats.ABILITIES)) {
                for (AbilityData abilityData : ((AbilityListData)volatileMMOItem.getData(ItemStats.ABILITIES)).getAbilities()) {
                    this.getMMOPlayerData().getPassiveSkillMap().addModifier((PlayerModifier)new PassiveSkill("MMOItemsItem", (Skill)abilityData, equipmentSlot, source));
                }
            }
            if (volatileMMOItem.hasData(ItemStats.PERM_EFFECTS)) {
                ((PotionEffectListData)volatileMMOItem.getData(ItemStats.PERM_EFFECTS)).getEffects().forEach(effect -> {
                    if (this.getPermanentPotionEffectAmplifier(effect.getType()) < effect.getLevel() - 1) {
                        this.permanentEffects.put(effect.getType(), effect.toEffect());
                    }
                });
            }
            if (volatileMMOItem.hasData(ItemStats.ITEM_PARTICLES)) {
                ParticleData particleData = (ParticleData)volatileMMOItem.getData(ItemStats.ITEM_PARTICLES);
                if (particleData.getType().hasPriority()) {
                    if (this.overridingItemParticles == null) {
                        this.overridingItemParticles = particleData.start(this);
                    }
                } else {
                    this.itemParticles.add(particleData.start(this));
                }
            }
            if (!MMOItems.plugin.hasPermissions() || !volatileMMOItem.hasData(ItemStats.GRANTED_PERMISSIONS)) continue;
            Permission perms = MMOItems.plugin.getVault().getPermissions();
            this.permissions.addAll(((StringListData)volatileMMOItem.getData(ItemStats.GRANTED_PERMISSIONS)).getList());
            this.permissions.forEach(perm -> {
                if (!perms.has(this.getPlayer(), perm)) {
                    perms.playerAdd(this.getPlayer(), perm);
                }
            });
        }
        HashMap<ItemSet, Integer> itemSetCount = new HashMap<ItemSet, Integer>();
        for (EquippedItem equippedItem : this.inventory.getEquipped()) {
            String tag = equippedItem.getCached().getNBT().getString("MMOITEMS_ITEM_SET");
            ItemSet itemSet = MMOItems.plugin.getSets().get(tag);
            if (itemSet == null) continue;
            itemSetCount.put(itemSet, itemSetCount.getOrDefault(itemSet, 0) + 1);
        }
        this.setBonuses = null;
        for (Map.Entry entry : itemSetCount.entrySet()) {
            if (this.setBonuses == null) {
                this.setBonuses = ((ItemSet)entry.getKey()).getBonuses((Integer)entry.getValue());
                continue;
            }
            this.setBonuses.merge(((ItemSet)entry.getKey()).getBonuses((Integer)entry.getValue()));
        }
        if (this.setBonuses != null) {
            if (MMOItems.plugin.hasPermissions()) {
                Permission permission = MMOItems.plugin.getVault().getPermissions();
                this.permissions.addAll(this.setBonuses.getPermissions());
                for (String perm2 : this.setBonuses.getPermissions()) {
                    if (permission.has(this.getPlayer(), perm2)) continue;
                    permission.playerAdd(this.getPlayer(), perm2);
                }
            }
            for (AbilityData abilityData : this.setBonuses.getAbilities()) {
                this.getMMOPlayerData().getPassiveSkillMap().addModifier((PlayerModifier)new PassiveSkill("MMOItemsItem", (Skill)abilityData, EquipmentSlot.OTHER, ModifierSource.OTHER));
            }
            for (ParticleData particleData : this.setBonuses.getParticles()) {
                this.itemParticles.add(particleData.start(this));
            }
            for (PotionEffect potionEffect : this.setBonuses.getPotionEffects()) {
                if (this.getPermanentPotionEffectAmplifier(potionEffect.getType()) >= potionEffect.getAmplifier()) continue;
                this.permanentEffects.put(potionEffect.getType(), potionEffect);
            }
        }
        this.stats.updateStats();
        MMOItems.plugin.getRPGs().forEach(rpg -> rpg.refreshStats(this));
        this.inventory.helmet = this.getPlayer().getInventory().getHelmet();
        this.inventory.chestplate = this.getPlayer().getInventory().getChestplate();
        this.inventory.leggings = this.getPlayer().getInventory().getLeggings();
        this.inventory.boots = this.getPlayer().getInventory().getBoots();
        this.inventory.hand = this.getPlayer().getInventory().getItemInMainHand();
        this.inventory.offhand = this.getPlayer().getInventory().getItemInOffHand();
    }

    public void timedRunnable() {
        this.permanentEffects.values().forEach(effect -> this.getPlayer().addPotionEffect(effect));
        if (this.encumbered) {
            this.getPlayer().addPotionEffect(new PotionEffect(VPotionEffectType.SLOWNESS.get(), 40, 1, true, false));
        }
    }

    public InventoryUpdateHandler getInventory() {
        return this.inventory;
    }

    public ItemSet.SetBonuses getSetBonuses() {
        return this.setBonuses;
    }

    public boolean hasSetBonuses() {
        return this.setBonuses != null;
    }

    public CraftingStatus getCrafting() {
        return this.craftingStatus;
    }

    public int getPermanentPotionEffectAmplifier(PotionEffectType type) {
        return this.permanentEffects.containsKey(type) ? this.permanentEffects.get(type).getAmplifier() : -1;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public Collection<PotionEffect> getPermanentPotionEffects() {
        return this.permanentEffects.values();
    }

    public PlayerStats getStats() {
        return this.stats;
    }

    @Deprecated
    public void cast(@Nullable AttackMetadata attack, @Nullable LivingEntity target, @NotNull AbilityData ability) {
        PlayerMetadata caster = this.getMMOPlayerData().getStatMap().cache(EquipmentSlot.MAIN_HAND);
        ability.cast(new TriggerMetadata(caster, (Entity)target, attack));
    }

    public boolean isOnCooldown(CooldownType type) {
        return this.getMMOPlayerData().getCooldownMap().isOnCooldown(type.name());
    }

    public void applyCooldown(CooldownType type, double value) {
        this.getMMOPlayerData().getCooldownMap().applyCooldown(type.name(), value);
    }

    @Deprecated
    public boolean isOnCooldown(ItemReference ref) {
        return this.getMMOPlayerData().getCooldownMap().isOnCooldown((CooldownObject)ref);
    }

    @Deprecated
    public void applyItemCooldown(ItemReference ref, double value) {
        this.getMMOPlayerData().getCooldownMap().applyCooldown((CooldownObject)ref, value);
    }

    @Deprecated
    public double getItemCooldown(ItemReference ref) {
        return (double)this.getMMOPlayerData().getCooldownMap().getInfo((CooldownObject)ref).getRemaining() / 1000.0;
    }

    @NotNull
    public static PlayerData get(@NotNull MMOPlayerData playerData) {
        return PlayerData.get((OfflinePlayer)playerData.getPlayer());
    }

    @NotNull
    public static PlayerData get(@NotNull OfflinePlayer player) {
        return PlayerData.get(player.getUniqueId());
    }

    public static boolean has(Player player) {
        return PlayerData.has(player.getUniqueId());
    }

    public static boolean has(UUID uuid) {
        return MMOItems.plugin.getPlayerDataManager().isLoaded(uuid);
    }

    @NotNull
    public static PlayerData get(UUID uuid) {
        return (PlayerData)MMOItems.plugin.getPlayerDataManager().get(uuid);
    }

    @Deprecated
    @NotNull
    public static Collection<PlayerData> getLoaded() {
        return MMOItems.plugin.getPlayerDataManager().getLoaded();
    }

    public static enum CooldownType {
        ELEMENTAL_ATTACK,
        SPECIAL_ATTACK,
        BOUNCING_CRACK;

    }
}

