/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.item.util.crafting;

import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.util.AdventureUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.Indyuce.mmoitems.api.crafting.ConditionalDisplay;
import net.Indyuce.mmoitems.api.crafting.condition.CheckedCondition;
import net.Indyuce.mmoitems.api.crafting.recipe.CheckedRecipe;
import net.Indyuce.mmoitems.api.crafting.recipe.UpgradingRecipe;
import net.Indyuce.mmoitems.api.item.util.ConfigItem;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class UpgradingRecipeDisplay
extends ConfigItem {
    public UpgradingRecipeDisplay() {
        super("UPGRADING_RECIPE_DISPLAY", Material.BARRIER, "&e&lUpgrade&f #name#", "{conditions}", "{conditions}&8Conditions:", "", "&8Ingredients:", "#ingredients#", "", "&eLeft-Click to craft!", "&eRight-Click to preview!");
    }

    public ItemBuilder newBuilder(CheckedRecipe recipe) {
        return new ItemBuilder(recipe);
    }

    public class ItemBuilder {
        private final CheckedRecipe recipe;
        private final UpgradingRecipe upgradingRecipe;
        private final String name;
        private final List<String> lore;

        public ItemBuilder(CheckedRecipe recipe) {
            this.name = UpgradingRecipeDisplay.this.getName();
            this.lore = new ArrayList<String>(UpgradingRecipeDisplay.this.getLore());
            this.recipe = recipe;
            this.upgradingRecipe = (UpgradingRecipe)recipe.getRecipe();
        }

        public ItemStack build() {
            HashMap<String, String> replace = new HashMap<String, String>();
            int conditionsIndex = -1;
            Iterator<String> iterator = this.lore.listIterator();
            while (iterator.hasNext()) {
                int index = iterator.nextIndex();
                String str = iterator.next();
                if (!str.startsWith("{conditions}")) continue;
                conditionsIndex = index;
                if (this.recipe.getConditions().size() == 0) {
                    iterator.remove();
                    continue;
                }
                replace.put(str, str.replace("{conditions}", ""));
            }
            for (String key : replace.keySet()) {
                this.lore.set(this.lore.indexOf(key), (String)replace.get(key));
            }
            int index = this.lore.indexOf("#ingredients#");
            this.lore.remove(index);
            this.recipe.getIngredients().forEach(info -> this.lore.add(index, info.format()));
            if (conditionsIndex >= 0) {
                for (CheckedCondition condition : this.recipe.getConditions()) {
                    ConditionalDisplay display = condition.getCondition().getDisplay();
                    if (display == null) continue;
                    this.lore.add(conditionsIndex++, condition.format());
                }
            }
            ItemStack item = this.upgradingRecipe.getItem().getPreview();
            ItemMeta meta = item.getItemMeta();
            AdventureUtils.setDisplayName((ItemMeta)meta, (String)this.name.replace("#name#", MMOUtils.getDisplayName(item)));
            AdventureUtils.setLore((ItemMeta)meta, this.lore);
            meta.addItemFlags(ItemFlag.values());
            item.setItemMeta(meta);
            return NBTItem.get((ItemStack)item).addTag(new ItemTag[]{new ItemTag("recipeId", (Object)this.recipe.getRecipe().getId())}).toItem();
        }
    }
}

