/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.item.util.crafting;

import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.util.AdventureUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.Indyuce.mmoitems.api.crafting.CraftingStatus;
import net.Indyuce.mmoitems.api.item.util.ConfigItem;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class QueueItemDisplay
extends ConfigItem {
    private static final long[] ms = new long[]{1000L, 60000L, 3600000L, 86400000L};
    private static final String[] chars = new String[]{"s", "m", "h", "d"};

    public QueueItemDisplay() {
        super("QUEUE_ITEM_DISPLAY", Material.BARRIER, "&6&lQueue&f #name#", "{ready}&7&oThis item was successfully crafted.", "{queue}&7&oThis item is in the crafting queue.", "{queue}", "{queue}&7Time Left: &c#left#", "", "{ready}&eClick to claim!", "{queue}&eClick to cancel.");
    }

    public ItemBuilder newBuilder(CraftingStatus.CraftingQueue.QueueItem crafting, int position) {
        return new ItemBuilder(crafting, position);
    }

    private String formatDelay(long delay) {
        StringBuilder format = new StringBuilder();
        int n = 0;
        for (int j = ms.length - 1; j >= 0 && n < 2; --j) {
            if (delay < ms[j]) continue;
            format.append(delay / ms[j]).append(chars[j]).append(" ");
            delay %= ms[j];
            ++n;
        }
        return format.length() == 0 ? "1s" : format.toString();
    }

    public class ItemBuilder {
        private final CraftingStatus.CraftingQueue.QueueItem crafting;
        private final int position;
        private final String name;
        private final List<String> lore;

        public ItemBuilder(CraftingStatus.CraftingQueue.QueueItem crafting, int position) {
            this.name = QueueItemDisplay.this.getName();
            this.lore = new ArrayList<String>(QueueItemDisplay.this.getLore());
            this.crafting = crafting;
            this.position = position;
        }

        public ItemStack build() {
            HashMap<String, String> replace = new HashMap<String, String>();
            Iterator<String> iterator = this.lore.iterator();
            while (iterator.hasNext()) {
                String str = iterator.next();
                if (str.startsWith("{queue}")) {
                    if (this.crafting.isReady()) {
                        iterator.remove();
                        continue;
                    }
                    replace.put(str, str.replace("{queue}", ""));
                }
                if (!str.startsWith("{ready}")) continue;
                if (!this.crafting.isReady()) {
                    iterator.remove();
                    continue;
                }
                replace.put(str, str.replace("{ready}", ""));
            }
            for (String key : replace.keySet()) {
                this.lore.set(this.lore.indexOf(key), ((String)replace.get(key)).replace("#left#", QueueItemDisplay.this.formatDelay(this.crafting.getLeft())));
            }
            ItemStack item = this.crafting.getRecipe().getPreviewItemStack();
            item.setAmount(this.position);
            ItemMeta meta = item.getItemMeta();
            AdventureUtils.setDisplayName((ItemMeta)meta, (String)this.name.replace("#name#", meta.getDisplayName()));
            AdventureUtils.setLore((ItemMeta)meta, this.lore);
            meta.addItemFlags(ItemFlag.values());
            item.setItemMeta(meta);
            return NBTItem.get((ItemStack)item).addTag(new ItemTag[]{new ItemTag("queueId", (Object)this.crafting.getUniqueId().toString())}).toItem();
        }
    }
}

