/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.item.util.crafting;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.util.AdventureUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.Indyuce.mmoitems.api.crafting.ConditionalDisplay;
import net.Indyuce.mmoitems.api.crafting.condition.CheckedCondition;
import net.Indyuce.mmoitems.api.crafting.recipe.CheckedRecipe;
import net.Indyuce.mmoitems.api.crafting.recipe.CraftingRecipe;
import net.Indyuce.mmoitems.api.item.util.ConfigItem;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CraftingRecipeDisplay
extends ConfigItem {
    public CraftingRecipeDisplay() {
        super("CRAFTING_RECIPE_DISPLAY", Material.BARRIER, "&a&lCraft&f #name#", "{conditions}", "{conditions}&8Conditions:", "{crafting_time}", "{crafting_time}&7Crafting Time: &c#crafting-time#&7s", "", "&8Ingredients:", "#ingredients#", "", "&eLeft-Click to craft!", "&eRight-Click to preview!");
    }

    public ItemBuilder newBuilder(CheckedRecipe recipe) {
        return new ItemBuilder(recipe);
    }

    public class ItemBuilder {
        private final CheckedRecipe recipe;
        private final CraftingRecipe craftingRecipe;
        private final String name;
        private final List<String> lore;

        public ItemBuilder(CheckedRecipe recipe) {
            this.name = CraftingRecipeDisplay.this.getName();
            this.lore = new ArrayList<String>(CraftingRecipeDisplay.this.getLore());
            this.recipe = recipe;
            this.craftingRecipe = (CraftingRecipe)recipe.getRecipe();
        }

        public ItemStack build() {
            HashMap<String, String> replace = new HashMap<String, String>();
            int conditionsIndex = -1;
            Iterator<String> iterator = this.lore.listIterator();
            while (iterator.hasNext()) {
                int index = iterator.nextIndex();
                String str = iterator.next();
                if (str.startsWith("{crafting_time}")) {
                    if (this.craftingRecipe.getCraftingTime() <= 0.0) {
                        iterator.remove();
                        continue;
                    }
                    replace.put(str, str.replace("{crafting_time}", "").replace("#crafting-time#", MythicLib.plugin.getMMOConfig().decimal.format(this.craftingRecipe.getCraftingTime())));
                }
                if (!str.startsWith("{conditions}")) continue;
                conditionsIndex = index + 1;
                if (this.recipe.getConditions().size() == 0) {
                    iterator.remove();
                    continue;
                }
                replace.put(str, str.replace("{conditions}", ""));
            }
            for (String key : replace.keySet()) {
                this.lore.set(this.lore.indexOf(key), (String)replace.get(key));
            }
            int index = this.lore.indexOf("#ingredients#");
            this.lore.remove(index);
            this.recipe.getIngredients().forEach(info -> this.lore.add(index, info.format()));
            if (conditionsIndex >= 0) {
                for (CheckedCondition condition : this.recipe.getConditions()) {
                    ConditionalDisplay display = condition.getCondition().getDisplay();
                    if (display == null) continue;
                    this.lore.add(conditionsIndex++, condition.format());
                }
            }
            ItemStack item = this.craftingRecipe.getPreviewItemStack();
            int amount = this.craftingRecipe.getOutputAmount();
            if (amount > 64) {
                this.lore.add(0, Message.STATION_BIG_STACK.format(ChatColor.GOLD, "#size#", String.valueOf(amount)).toString());
            } else {
                item.setAmount(amount);
            }
            ItemMeta meta = item.getItemMeta();
            meta.addItemFlags(ItemFlag.values());
            AdventureUtils.setDisplayName((ItemMeta)meta, (String)this.name.replace("#name#", (amount > 1 ? ChatColor.WHITE + "" + amount + " x " : "") + MMOUtils.getDisplayName(item)));
            AdventureUtils.setLore((ItemMeta)meta, this.lore);
            item.setItemMeta(meta);
            return NBTItem.get((ItemStack)item).addTag(new ItemTag[]{new ItemTag("recipeId", (Object)this.craftingRecipe.getId())}).toItem();
        }
    }
}

