/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.item.util;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import io.lumine.mythic.lib.util.AdventureUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

public class ConfigItem {
    private final String id;
    @Deprecated
    private final ItemStack icon;
    private String name;
    private List<String> lore;
    @Deprecated
    private ItemStack item;
    @Deprecated
    @Nullable
    protected Material material = null;
    @Deprecated
    @Nullable
    protected Integer customModelData = null;

    public ConfigItem(String id, Material material) {
        this(id, material, null, new String[0]);
    }

    public ConfigItem(String id, Material material, String name, String ... lore) {
        Validate.notNull((Object)id, (String)"ID cannot be null");
        Validate.notNull((Object)material, (String)"Material cannot be null");
        this.id = id;
        this.icon = new ItemStack(material);
        this.name = name;
        this.lore = Arrays.asList(lore);
    }

    public ConfigItem(ConfigurationSection config) {
        Validate.notNull((Object)config, (String)"Config cannot be null");
        this.id = config.getName();
        Validate.isTrue((boolean)config.contains("material"), (String)"Could not find material");
        this.icon = MMOUtils.readIcon(config.getString("material"));
        this.name = config.getString("name", "");
        this.lore = config.getStringList("lore");
        this.updateItem();
    }

    public String getId() {
        return this.id;
    }

    @Deprecated
    public void setup(ConfigurationSection config) {
        config.set("name", (Object)this.getName());
        config.set("lore", this.getLore());
    }

    @Deprecated
    public void update(ConfigurationSection config) {
        Validate.notNull((Object)config, (String)"Config cannot be null");
        this.setName(config.getString("name", ""));
        this.setLore(config.contains("lore") ? config.getStringList("lore") : new ArrayList());
        String mat = config.getString("material");
        if (mat != null && !mat.isEmpty()) {
            try {
                Material m = Material.valueOf((String)config.getString("material"));
                if (m.isItem()) {
                    this.setMaterial(m);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.setModel(SilentNumbers.IntegerParse((String)config.getString("model")));
        this.updateItem();
    }

    public void updateItem() {
        this.setItem(this.icon);
        if (this.icon.getType() == Material.AIR) {
            return;
        }
        ItemMeta meta = this.item.getItemMeta();
        AdventureUtils.setDisplayName((ItemMeta)meta, (String)this.name);
        meta.addItemFlags(ItemFlag.values());
        if (this.hasLore()) {
            AdventureUtils.setLore((ItemMeta)meta, this.getLore().stream().map(s -> ChatColor.GRAY + s).collect(Collectors.toList()));
        }
        this.item.setItemMeta(meta);
        this.item = MythicLib.plugin.getVersion().getWrapper().getNBTItem(this.item).addTag(new ItemTag[]{new ItemTag("ItemId", (Object)this.id)}).toItem();
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public boolean hasLore() {
        return this.lore != null;
    }

    @Deprecated
    public ItemStack getItem() {
        return this.item;
    }

    @Deprecated
    public ItemStack getNewItem() {
        return this.item.clone();
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setLore(List<String> lore) {
        this.lore = lore;
    }

    @Deprecated
    protected void setItem(ItemStack item) {
        this.item = item;
    }

    @Deprecated
    protected void setMaterial(@Nullable Material mat) {
        this.material = mat;
    }

    @Deprecated
    protected void setModel(@Nullable Integer cmd) {
        this.customModelData = cmd;
    }
}

