/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.item.template;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackCategory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackPalette;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.util.PostLoadAction;
import io.lumine.mythic.lib.util.PreloadedObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ItemTier;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.item.ItemReference;
import net.Indyuce.mmoitems.api.item.build.MMOItemBuilder;
import net.Indyuce.mmoitems.api.item.template.ModifierNode;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.player.RPGPlayer;
import net.Indyuce.mmoitems.api.util.NumericStatFormula;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import net.Indyuce.mmoitems.stat.data.random.RandomStatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import org.apache.commons.lang.Validate;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MMOItemTemplate
implements ItemReference,
PreloadedObject {
    private final Type type;
    private final String id;
    private final int revId;
    private final Map<ItemStat, RandomStatData> base = new HashMap<ItemStat, RandomStatData>();
    @Nullable
    private NumericStatFormula modifierCapacity;
    @Nullable
    private ModifierNode modifierGroup;
    private final Set<TemplateOption> options = new HashSet<TemplateOption>();
    private final PostLoadAction postLoadAction = new PostLoadAction(config -> {
        FriendlyFeedbackProvider ffp = new FriendlyFeedbackProvider((FriendlyFeedbackPalette)FFPMMOItems.get());
        ffp.activatePrefix(true, this.getType().getId() + " " + this.getId());
        if (config.contains("option")) {
            if (config.contains("option.capacity", true)) {
                try {
                    this.modifierCapacity = new NumericStatFormula(config.getConfigurationSection("option.capacity"));
                }
                catch (RuntimeException exception) {
                    ffp.log(FriendlyFeedbackCategory.ERROR, "Could not load modifier capacity: {0}", new String[]{exception.getMessage()});
                }
            }
            for (TemplateOption option : TemplateOption.values()) {
                if (!config.getBoolean("option." + option.name().toLowerCase().replace("_", "-"))) continue;
                this.options.add(option);
            }
        }
        try {
            ModifierNode modifierNode = this.modifierGroup = config.contains("modifiers") ? new ModifierNode(this.getId(), config) : null;
            if (this.modifierGroup != null) {
                this.modifierGroup.getPostLoadAction().performAction();
            }
        }
        catch (Exception exception) {
            ffp.log(FriendlyFeedbackCategory.ERROR, "Could not load modifier group: {0}", new String[]{exception.getMessage()});
        }
        Validate.notNull((Object)config.getConfigurationSection("base"), (String)FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Could not find base item data", (String[])new String[0]));
        for (String key : config.getConfigurationSection("base").getKeys(false)) {
            try {
                String id = UtilityMethods.enumName((String)key);
                ItemStat<?, ?> stat = MMOItems.plugin.getStats().get(id);
                Validate.notNull(stat, (String)FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Could not find stat with ID '$i{0}$b'", (String[])new String[]{id}));
                Object data = stat.whenInitialized(config.get("base." + key));
                if (data == null) continue;
                this.base.put(stat, (RandomStatData)data);
            }
            catch (IllegalArgumentException exception) {
                ffp.log(FriendlyFeedbackCategory.INFORMATION, "Could not load base item data '$f{0}$b': {1}", new String[]{key, exception.getMessage()});
            }
        }
        ffp.sendTo(FriendlyFeedbackCategory.INFORMATION, MMOItems.getConsole());
    });

    public MMOItemTemplate(Type type, String id) {
        this.type = type;
        this.id = id;
        this.revId = 1;
    }

    public MMOItemTemplate(Type type, ConfigurationSection config2) {
        Validate.notNull((Object)config2, (String)"Could not load template config");
        this.postLoadAction.cacheConfig(config2);
        this.type = type;
        this.id = config2.getName().toUpperCase().replace("-", "_").replace(" ", "_");
        this.revId = config2.getInt("base.revision-id", 1);
    }

    @NotNull
    public PostLoadAction getPostLoadAction() {
        return this.postLoadAction;
    }

    @NotNull
    public Map<ItemStat, RandomStatData> getBaseItemData() {
        return this.base;
    }

    @Nullable
    public ModifierNode getModifierGroup() {
        return this.modifierGroup;
    }

    public boolean hasModifierGroup() {
        return this.modifierGroup != null;
    }

    @Nullable
    public NumericStatFormula getModifierCapacity() {
        return this.modifierCapacity;
    }

    public boolean hasModifierCapacity() {
        return this.modifierCapacity != null;
    }

    @Deprecated
    @NotNull
    public Map<String, ModifierNode> getModifiers() {
        HashMap<String, ModifierNode> built = new HashMap<String, ModifierNode>();
        if (this.modifierGroup != null) {
            this.exploreMap(built, this.modifierGroup);
        }
        return built;
    }

    private void exploreMap(Map<String, ModifierNode> built, ModifierNode node) {
        node.getChildren().forEach(child -> this.exploreMap(built, (ModifierNode)child));
        built.put(node.getId(), node);
    }

    @Deprecated
    public boolean hasModifier(String id) {
        return this.getModifiers().containsKey(id);
    }

    @Nullable
    @Deprecated
    public ModifierNode getModifier(String id) {
        return this.getModifiers().get(id);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public int getRevisionId() {
        return this.revId;
    }

    public boolean hasOption(TemplateOption option) {
        return this.options.contains((Object)option);
    }

    public MMOItemBuilder newBuilder() {
        return this.newBuilder((RPGPlayer)null);
    }

    public MMOItemBuilder newBuilder(@Nullable Player player) {
        return this.newBuilder(player == null ? null : PlayerData.get((OfflinePlayer)player).getRPG());
    }

    public MMOItemBuilder newBuilder(@Nullable PlayerData player) {
        return this.newBuilder(player == null ? null : player.getRPG());
    }

    public MMOItemBuilder newBuilder(@Nullable RPGPlayer player) {
        return this.newBuilder(player, false);
    }

    @NotNull
    public MMOItemBuilder newBuilder(@Nullable RPGPlayer player, boolean forDisplay) {
        if (player == null) {
            return this.newBuilder(0, null);
        }
        int itemLevel = this.hasOption(TemplateOption.LEVEL_ITEM) ? MMOItems.plugin.getTemplates().rollLevel(player.getLevel()) : 0;
        ItemTier itemTier = this.hasOption(TemplateOption.TIERED) ? MMOItems.plugin.getTemplates().rollTier() : null;
        return new MMOItemBuilder(this, itemLevel, itemTier, forDisplay);
    }

    @NotNull
    public MMOItemBuilder newBuilder(int itemLevel, @Nullable ItemTier itemTier) {
        return new MMOItemBuilder(this, itemLevel, itemTier);
    }

    @Deprecated
    public int getCraftedAmount() {
        return 1;
    }

    public static enum TemplateOption {
        ROLL_MODIFIER_CHECK_ORDER,
        TIERED,
        LEVEL_ITEM;

    }
}

