/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.item.build;

import com.google.common.collect.Lists;
import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.util.formula.NumericalExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ItemTier;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.tooltip.TooltipTexture;
import net.Indyuce.mmoitems.util.Buildable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoreBuilder
extends Buildable<List<String>> {
    private final List<String> lore = new ArrayList<String>();
    private final List<String> end = new ArrayList<String>();
    private final Map<String, String> placeholders = new HashMap<String, String>();
    private final TooltipTexture tooltip;
    private static final String LINE_PREFIX = ChatColor.WHITE.toString();

    @Deprecated
    public LoreBuilder(@NotNull Collection<String> format) {
        this.lore.addAll(format);
        this.tooltip = null;
    }

    public LoreBuilder(@NotNull MMOItem mmoitem) {
        this.lore.addAll(MMOItems.plugin.getLore().getFormat(mmoitem));
        this.tooltip = mmoitem.getTooltip();
        this.registerPlaceholder("type", mmoitem.getType().getName());
        ItemTier tier = mmoitem.getTier();
        this.registerPlaceholder("tier", tier != null ? tier.getName() : MMOItems.plugin.getLanguage().defaultTierName);
    }

    public void insert(int index, @NotNull String element) {
        this.lore.add(index, element);
    }

    public void insert(int index, @NotNull Collection<String> elements) {
        this.lore.addAll(index, elements);
    }

    public void insert(String path, String ... add) {
        int index = this.lore.indexOf("#" + path + "#");
        if (index < 0) {
            return;
        }
        for (int j = 0; j < add.length; ++j) {
            this.lore.add(index + 1, add[add.length - j - 1]);
        }
        this.lore.remove(index);
    }

    public void insert(@NotNull String path, @NotNull List<String> list) {
        int index = this.lore.indexOf("#" + path + "#");
        if (index < 0) {
            return;
        }
        Lists.reverse(list).forEach(string -> this.lore.add(index + 1, (String)string));
        this.lore.remove(index);
    }

    public void registerPlaceholder(@NotNull String path, @Nullable Object value) {
        this.placeholders.put(path, String.valueOf(value));
    }

    @NotNull
    public String applySpecialPlaceholders(String str) {
        int max;
        int min = str.indexOf("{");
        while (min >= 0 && (max = str.indexOf("}", min)) >= 0) {
            String placeholder = str.substring(min + 1, max);
            String value = this.placeholders.get(placeholder);
            if (value != null) {
                str = str.substring(0, min) + value + str.substring(max + 1);
                max += value.length() - placeholder.length() - 2;
            }
            min = str.indexOf("{", max + 1);
        }
        return str;
    }

    @Deprecated
    public void end(@NotNull String str) {
        this.end.add(str);
    }

    @Override
    protected List<String> whenBuilt() {
        String tooltipSuffix;
        int j = 0;
        while (j < this.lore.size()) {
            int n = this.lore.size() - j - 1;
            String line = this.lore.get(n);
            if (line.startsWith("#")) {
                this.lore.remove(n);
                continue;
            }
            if (line.startsWith("{bar}") && (j == 0 || this.getType(n + 1).isBar())) {
                this.lore.remove(n);
                continue;
            }
            ++j;
        }
        String string = tooltipSuffix = this.tooltip != null ? this.tooltip.getSuffix() : "";
        if (this.tooltip != null) {
            this.lore.add(this.tooltip.getBottom() + tooltipSuffix);
            if (this.tooltip.getLoreHeader() != null) {
                this.lore.addAll(0, this.tooltip.getLoreHeader());
            }
        }
        int linesIgnored = this.tooltip != null ? this.tooltip.getFirstIgnored() : 0;
        int j2 = 0;
        while (j2 < this.lore.size()) {
            String match;
            String currentLine = this.lore.get(j2);
            LineType lineType = this.getType(j2, currentLine);
            if (lineType.isNormalBar()) {
                currentLine = currentLine.substring(5);
            }
            if (lineType.isSuperBar()) {
                currentLine = currentLine.substring(6);
            }
            if (this.tooltip != null && !lineType.isBottom()) {
                currentLine = (j2 < linesIgnored ? this.tooltip.getAlignText() : (lineType.isBar() ? this.tooltip.getBar() : this.tooltip.getMiddle())) + currentLine;
            }
            if ((match = StringUtils.substringBetween((String)currentLine, (String)"MATH%", (String)"%")) != null) {
                currentLine = currentLine.replaceFirst("MATH\\%[^%]*\\%", this.evaluate(match));
            }
            currentLine = MythicLib.plugin.getPlaceholderParser().parse(null, currentLine);
            String[] split = (currentLine = this.applySpecialPlaceholders(currentLine)).split("\n", -1);
            if (split.length > 1) {
                for (int k = split.length - 1; k >= 0; --k) {
                    this.lore.add(j2, LINE_PREFIX + split[k] + (j2 < linesIgnored ? "" : tooltipSuffix));
                }
                this.lore.remove(j2 + split.length);
                j2 += split.length;
                continue;
            }
            this.lore.set(j2++, LINE_PREFIX + currentLine + tooltipSuffix);
        }
        if (this.tooltip != null && this.tooltip.getCenteringOptions() != null) {
            for (j2 = 0; j2 < this.tooltip.getCenteringOptions().getLoreLines(); ++j2) {
                this.lore.set(j2, this.tooltip.getCenteringOptions().centerLore(j2, this.lore.get(j2)));
            }
        }
        this.lore.addAll(this.end);
        return this.lore;
    }

    @NotNull
    private LineType getType(int index) {
        return this.getType(index, this.lore.get(index));
    }

    @NotNull
    private LineType getType(int index, String line) {
        if (index == this.lore.size() - 1) {
            if (line.startsWith("{bar}")) {
                return LineType.BAR;
            }
            if (line.startsWith("{sbar}")) {
                return LineType.SUPERBAR;
            }
            return LineType.BOTTOM;
        }
        if (line.startsWith("{bar}")) {
            return LineType.BAR;
        }
        if (line.startsWith("{sbar}")) {
            return LineType.SUPERBAR;
        }
        return LineType.MIDDLE;
    }

    @Deprecated
    private String evaluate(String formula) {
        try {
            return String.valueOf(NumericalExpression.eval((String)formula));
        }
        catch (Throwable throwable) {
            return "<ParsingError>";
        }
    }

    @NotNull
    public List<String> getLore() {
        return this.lore;
    }

    public boolean hasTooltip() {
        return this.tooltip != null;
    }

    @NotNull
    public TooltipTexture getTooltip() {
        return Objects.requireNonNull(this.tooltip);
    }

    public void setLore(List<String> lore) {
        this.lore.clear();
        this.lore.addAll(lore);
    }

    @Override
    @NotNull
    public List<String> build() {
        return (List)super.build();
    }

    private static enum LineType {
        MIDDLE,
        BAR,
        SUPERBAR,
        BOTTOM,
        BOTTOM_BAR,
        BOTTOM_SUPERBAR;


        boolean isBar() {
            return this.isNormalBar() || this.isSuperBar();
        }

        boolean isBottom() {
            return this == BOTTOM || this == BOTTOM_BAR || this == BOTTOM_SUPERBAR;
        }

        boolean isSuperBar() {
            return this == SUPERBAR || this == BOTTOM_SUPERBAR;
        }

        boolean isNormalBar() {
            return this == BAR || this == BOTTOM_BAR;
        }
    }
}

