/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.item.build;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.gson.JsonArray;
import io.lumine.mythic.lib.util.AdventureUtils;
import io.lumine.mythic.lib.version.Attributes;
import io.lumine.mythic.lib.version.VersionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.event.GenerateLoreEvent;
import net.Indyuce.mmoitems.api.event.ItemBuildEvent;
import net.Indyuce.mmoitems.api.item.build.LoreBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.stat.data.MaterialData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.stat.type.Previewable;
import net.Indyuce.mmoitems.stat.type.StatHistory;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemStackBuilder {
    @NotNull
    private final MMOItem mmoitem;
    private final ItemStack item;
    private final ItemMeta meta;
    private final LoreBuilder lore;
    private final List<ItemTag> tags = new ArrayList<ItemTag>();
    @Deprecated
    private List<Consumer<NBTItem>> futureActions;
    private static final AttributeModifier FAKE_MODIFIER = VersionUtils.attrMod((NamespacedKey)new NamespacedKey((Plugin)MMOItems.plugin, "decoy"), (double)0.0, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_NUMBER);
    public static final String history_keyword = "HSTRY_";

    public ItemStackBuilder(@NotNull MMOItem mmoitem) {
        this.mmoitem = mmoitem;
        this.item = new ItemStack(mmoitem.hasData(ItemStats.MATERIAL) ? ((MaterialData)mmoitem.getData(ItemStats.MATERIAL)).getMaterial() : Material.DIAMOND_SWORD);
        this.lore = new LoreBuilder(mmoitem);
        this.meta = this.item.getItemMeta();
        this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        this.tags.add(new ItemTag("MMOITEMS_ITEM_TYPE", (Object)mmoitem.getType().getId()));
        this.tags.add(new ItemTag("MMOITEMS_ITEM_ID", (Object)mmoitem.getId()));
    }

    public LoreBuilder getLore() {
        return this.lore;
    }

    @NotNull
    public MMOItem getMMOItem() {
        return this.mmoitem;
    }

    @NotNull
    public ItemStack getItemStack() {
        return this.item;
    }

    @NotNull
    public ItemMeta getMeta() {
        return this.meta;
    }

    @Deprecated
    public void addFutureAction(Consumer<NBTItem> action) {
        if (this.futureActions == null) {
            this.futureActions = new ArrayList<Consumer<NBTItem>>();
        }
        this.futureActions.add(action);
    }

    public void addItemTag(List<ItemTag> newTags) {
        this.tags.addAll(newTags);
    }

    public void addItemTag(ItemTag ... itemTags) {
        this.tags.addAll(Arrays.asList(itemTags));
    }

    public NBTItem buildNBT() {
        return this.buildNBT(false);
    }

    public NBTItem buildNBT(boolean forDisplay) {
        MMOItem builtMMOItem = this.mmoitem.clone();
        builtMMOItem.computeData(ItemStats.ENCHANTS);
        builtMMOItem.computeStatHistory(ItemStats.ENCHANTS);
        builtMMOItem.computeData(ItemStats.NAME);
        builtMMOItem.computeStatHistory(ItemStats.NAME);
        for (ItemStat stat : builtMMOItem.getStats()) {
            try {
                StatHistory s = builtMMOItem.getStatHistory(stat);
                if (s != null) {
                    int l = this.mmoitem.getUpgradeLevel();
                    builtMMOItem.setData(stat, s.recalculate(l));
                    if (!s.isEmpty()) {
                        this.addItemTag(new ItemTag(history_keyword + stat.getId(), (Object)s.toNBTString()));
                    }
                }
                if (forDisplay && stat instanceof Previewable) {
                    MMOItemTemplate template = MMOItems.plugin.getTemplates().getTemplate(builtMMOItem.getType(), builtMMOItem.getId());
                    if (template == null) {
                        throw new IllegalArgumentException("MMOItem $r" + builtMMOItem.getType().getId() + " " + builtMMOItem.getId() + "$b doesn't exist.");
                    }
                    ((Previewable)((Object)stat)).whenPreviewed(this, builtMMOItem.getData(stat), template.getBaseItemData().get(stat));
                    continue;
                }
                stat.whenApplied(this, builtMMOItem.getData(stat));
            }
            catch (IllegalArgumentException | NullPointerException exception) {
                MMOItems.print(Level.SEVERE, "An error occurred while trying to generate item '$f{0}$b' with stat '$f{1}$b': {2}", "ItemStackBuilder", builtMMOItem.getId(), stat.getId(), exception.getMessage());
            }
        }
        if (builtMMOItem.getType() == Type.GEM_STONE) {
            this.lore.insert("gem-stone-lore", MMOItems.plugin.getLanguage().gemStoneLoreTag);
        }
        this.lore.insert("item-type", MMOItems.plugin.getLanguage().itemTypeLoreTag.replace("{type}", builtMMOItem.getStats().contains(ItemStats.DISPLAYED_TYPE) ? builtMMOItem.getData(ItemStats.DISPLAYED_TYPE).toString() : builtMMOItem.getType().getName()));
        List<String> unparsedLore = this.lore.getLore();
        Object parsedLore = this.lore.build();
        GenerateLoreEvent event = new GenerateLoreEvent(builtMMOItem, this.lore, (List<String>)parsedLore, unparsedLore);
        Bukkit.getPluginManager().callEvent((Event)event);
        AdventureUtils.setLore((ItemMeta)this.meta, event.getParsedLore());
        if (this.meta.hasDisplayName()) {
            String displayName = this.meta.getDisplayName();
            if (this.lore.hasTooltip()) {
                displayName = this.lore.getTooltip().getTop() + displayName;
            }
            displayName = MythicLib.plugin.getPlaceholderParser().parse(null, displayName);
            displayName = this.lore.applySpecialPlaceholders(displayName);
            if (this.lore.hasTooltip() && this.lore.getTooltip().getCenteringOptions() != null && this.lore.getTooltip().getCenteringOptions().displayName()) {
                displayName = this.lore.getTooltip().getCenteringOptions().centerName(displayName);
            }
            AdventureUtils.setDisplayName((ItemMeta)this.meta, (String)(ChatColor.WHITE + displayName));
        }
        JsonArray array = new JsonArray();
        event.getParsedLore().forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        if (!array.isEmpty()) {
            this.tags.add(new ItemTag("MMOITEMS_DYNAMIC_LORE", (Object)array.toString()));
        }
        this.meta.addAttributeModifier(Attributes.ATTACK_SPEED, FAKE_MODIFIER);
        this.item.setItemMeta(this.meta);
        NBTItem nbt = NBTItem.get((ItemStack)this.item).addTag(this.tags);
        if (this.futureActions != null) {
            this.futureActions.forEach(a -> a.accept(nbt));
        }
        return nbt;
    }

    @Nullable
    public ItemStack build() {
        ItemBuildEvent event = new ItemBuildEvent(this.buildNBT().toItem());
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return event.getItemStack();
    }

    public ItemStack buildSilently() {
        return this.buildNBT().toItem();
    }

    public ItemStack build(boolean forDisplay) {
        return this.buildNBT(forDisplay).toItem();
    }
}

