/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.interaction.util;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.gson.JsonParser;
import io.lumine.mythic.lib.gson.JsonSyntaxException;
import io.lumine.mythic.lib.version.Sounds;
import io.lumine.mythic.lib.version.VEnchantment;
import java.util.Objects;
import java.util.Random;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.api.event.item.CustomDurabilityDamage;
import net.Indyuce.mmoitems.api.event.item.ItemCustomRepairEvent;
import net.Indyuce.mmoitems.api.item.mmoitem.LiveMMOItem;
import net.Indyuce.mmoitems.api.item.util.LoreUpdate;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.stat.data.DoubleData;
import net.Indyuce.mmoitems.stat.data.UpgradeData;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DurabilityItem {
    private final NBTItem nbtItem;
    private final int maxDurability;
    private final int unbreakingLevel;
    private final int initialDurability;
    private final boolean barHidden;
    private final Player player;
    private int durability;
    private static final Random RANDOM = new Random();

    public DurabilityItem(@NotNull Player player, @NotNull ItemStack item) {
        this(player, NBTItem.get((ItemStack)item));
    }

    public DurabilityItem(@NotNull Player player, @NotNull NBTItem nbtItem) {
        this.player = Objects.requireNonNull(player, "Player cannot be null");
        this.nbtItem = Objects.requireNonNull(nbtItem, "Item cannot be null");
        this.maxDurability = nbtItem.getInteger("MMOITEMS_MAX_DURABILITY");
        this.durability = nbtItem.hasTag("MMOITEMS_DURABILITY") ? nbtItem.getInteger("MMOITEMS_DURABILITY") : this.maxDurability;
        this.initialDurability = this.durability;
        this.barHidden = nbtItem.getBoolean("MMOITEMS_DURABILITY_BAR");
        this.unbreakingLevel = MMOUtils.getLevel(nbtItem.getItem(), VEnchantment.UNBREAKING.get());
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getMaxDurability() {
        return this.maxDurability;
    }

    public int getDurability() {
        return this.durability;
    }

    public boolean isBarHidden() {
        return this.barHidden;
    }

    public int getUnbreakingLevel() {
        return this.unbreakingLevel;
    }

    public NBTItem getNBTItem() {
        return this.nbtItem;
    }

    public boolean isBroken() {
        return this.maxDurability > 0 && this.durability <= 0;
    }

    public boolean isLostWhenBroken() {
        return this.nbtItem.getBoolean("MMOITEMS_WILL_BREAK");
    }

    public boolean isDowngradedWhenBroken() {
        return this.nbtItem.getBoolean("MMOITEMS_BREAK_DOWNGRADE");
    }

    public boolean isValid() {
        return this.maxDurability > 0 && this.player.getGameMode() != GameMode.CREATIVE;
    }

    @NotNull
    public DurabilityItem addDurability(int gain) {
        Validate.isTrue((gain > 0 ? 1 : 0) != 0, (String)"Durability gain must be greater than 0");
        ItemCustomRepairEvent event = new ItemCustomRepairEvent(this, gain);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return this;
        }
        this.durability = Math.min(this.durability + gain, this.maxDurability);
        return this;
    }

    public DurabilityItem decreaseDurability(int loss) {
        int unbreakingLevel;
        if (loss == 0) {
            return this;
        }
        if (this.nbtItem.getItem().getType().getMaxDurability() == 0 && (unbreakingLevel = this.getUnbreakingLevel()) > 0 && RANDOM.nextInt(unbreakingLevel + 1) != 0) {
            return this;
        }
        CustomDurabilityDamage event = new CustomDurabilityDamage(this, loss);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return this;
        }
        this.durability = Math.max(0, Math.min(this.durability - loss, this.maxDurability));
        if (this.isBroken()) {
            this.player.getWorld().playSound(this.player.getLocation(), Sounds.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            PlayerData.get((OfflinePlayer)this.player).getInventory().scheduleUpdate();
        }
        return this;
    }

    @Nullable
    public ItemStack toItem() {
        if (this.isBroken()) {
            ItemTag uTag;
            if (this.isLostWhenBroken()) {
                return null;
            }
            if (this.isDowngradedWhenBroken() && (uTag = ItemTag.getTagAtPath((String)ItemStats.UPGRADE.getNBTPath(), (NBTItem)this.getNBTItem(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING)) != null) {
                try {
                    UpgradeData data = new UpgradeData(new JsonParser().parse((String)uTag.getValue()).getAsJsonObject());
                    if (data.getLevel() <= data.getMin()) {
                        return null;
                    }
                    LiveMMOItem mmo = new LiveMMOItem(this.getNBTItem());
                    mmo.setData(ItemStats.CUSTOM_DURABILITY, new DoubleData(this.maxDurability));
                    mmo.getUpgradeTemplate().upgradeTo(mmo, data.getLevel() - 1);
                    return mmo.newBuilder().buildNBT().toItem();
                }
                catch (JsonSyntaxException | IllegalStateException data) {
                    // empty catch block
                }
            }
        }
        if (this.durability == this.initialDurability) {
            return this.nbtItem.getItem();
        }
        this.nbtItem.addTag(new ItemTag[]{new ItemTag("MMOITEMS_DURABILITY", (Object)this.durability)});
        ItemStack item = this.nbtItem.toItem();
        if (!this.barHidden && item.getType().getMaxDurability() > 0) {
            int damage = this.durability == this.maxDurability ? 0 : Math.max(1, (int)((1.0 - (double)this.durability / (double)this.maxDurability) * (double)this.nbtItem.getItem().getType().getMaxDurability()));
            ItemMeta meta = item.getItemMeta();
            ((Damageable)meta).setDamage(damage);
            item.setItemMeta(meta);
        }
        String format = MythicLib.inst().parseColors(ItemStats.ITEM_DAMAGE.getGeneralStatFormat().replace("{max}", String.valueOf(this.maxDurability)));
        String old = format.replace("{current}", String.valueOf(this.initialDurability));
        String replaced = format.replace("{current}", String.valueOf(this.durability));
        return new LoreUpdate(item, old, replaced).updateLore();
    }
}

