/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.interaction;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.comp.flags.CustomFlag;
import io.lumine.mythic.lib.version.OreDrops;
import io.lumine.mythic.lib.version.Sounds;
import io.lumine.mythic.lib.version.VEnchantment;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.event.BouncingCrackBlockBreakEvent;
import net.Indyuce.mmoitems.api.interaction.weapon.Weapon;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class Tool
extends Weapon {
    private static final BlockFace[] NEIGHBORS = new BlockFace[]{BlockFace.NORTH, BlockFace.DOWN, BlockFace.EAST, BlockFace.UP, BlockFace.WEST, BlockFace.SOUTH};

    public Tool(PlayerData playerData, NBTItem item) {
        super(playerData, item);
    }

    @Deprecated
    public Tool(Player player, NBTItem item) {
        super(player, item);
    }

    @Override
    public CustomFlag getUseFlag() {
        return CustomFlag.MI_TOOLS;
    }

    public boolean miningEffects(final @NotNull Block block) {
        OreDrops drops;
        boolean cancel = false;
        if (this.getNBTItem().getBoolean("MMOITEMS_AUTOSMELT") && (drops = MythicLib.plugin.getVersion().getWrapper().getOreDrops(block.getType())) != null) {
            int fortuneLevel = MMOUtils.getLevel(this.getItem(), VEnchantment.FORTUNE.get());
            UtilityMethods.dropItemNaturally((Location)block.getLocation(), (ItemStack)drops.generate(fortuneLevel));
            block.getWorld().spawnParticle(Particle.LAVA, block.getLocation().add(0.5, 0.5, 0.5), 4);
            block.setType(Material.AIR);
            cancel = true;
        }
        if (this.getNBTItem().getBoolean("MMOITEMS_BOUNCING_CRACK") && !this.getPlayerData().isOnCooldown(PlayerData.CooldownType.BOUNCING_CRACK)) {
            this.getPlayerData().applyCooldown(PlayerData.CooldownType.BOUNCING_CRACK, 1.0);
            new BukkitRunnable(){
                final Vector globalDirection;
                final Vector point1;
                final Vector point2;
                final double[] products;
                Block curr;
                int j;
                private static final int BLOCKS_BROKEN = 4;
                {
                    this.globalDirection = Tool.this.player.getEyeLocation().getDirection();
                    this.point1 = block.getLocation().add(0.5, 0.5, 0.5).toVector();
                    this.point2 = this.point1.clone().add(this.globalDirection);
                    this.products = new double[NEIGHBORS.length];
                    for (BlockFace face : NEIGHBORS) {
                        this.products[face.ordinal()] = face.getDirection().dot(this.globalDirection);
                    }
                    this.curr = block;
                    this.j = 0;
                }

                public void run() {
                    if (++this.j >= 4) {
                        this.cancel();
                    }
                    this.curr = this.findBestBlock();
                    if (this.curr.getType() == Material.AIR || MMOItems.plugin.getLanguage().isBlacklisted(this.curr.getType())) {
                        return;
                    }
                    BouncingCrackBlockBreakEvent breakEvent = new BouncingCrackBlockBreakEvent(this.curr, Tool.this.player);
                    Bukkit.getPluginManager().callEvent((Event)breakEvent);
                    if (breakEvent.isCancelled()) {
                        this.cancel();
                        return;
                    }
                    this.curr.breakNaturally(Tool.this.getItem());
                    this.curr.getWorld().playSound(this.curr.getLocation(), Sounds.BLOCK_GRAVEL_BREAK, 1.0f, 1.0f);
                }

                @NotNull
                private Block findBestBlock() {
                    Block block2 = null;
                    double cost = Double.MAX_VALUE;
                    for (BlockFace candidate : NEIGHBORS) {
                        Block candidateBlock = this.curr.getRelative(candidate);
                        double candidateCost = this.findCost(candidate, candidateBlock);
                        if (!(candidateCost < cost)) continue;
                        cost = candidateCost;
                        block2 = candidateBlock;
                    }
                    return block2;
                }

                private double findCost(BlockFace candidate, Block candidateBlock) {
                    Vector center = candidateBlock.getLocation().add(0.5, 0.5, 0.5).toVector();
                    return Tool.this.dist(center, this.point1, this.point2) - this.products[candidate.ordinal()];
                }
            }.runTaskTimer((Plugin)MMOItems.plugin, 0L, 1L);
        }
        return cancel;
    }

    private double dist(Vector a, Vector b, Vector c) {
        Vector ab = b.clone().subtract(a);
        Vector bc = c.clone().subtract(b);
        return ab.getCrossProduct(bc).length() / bc.length();
    }
}

