/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.interaction;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.version.Sounds;
import java.util.List;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.interaction.UseItem;
import net.Indyuce.mmoitems.api.item.mmoitem.VolatileMMOItem;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.stat.data.SkullTextureData;
import net.Indyuce.mmoitems.stat.data.StringListData;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

public class ItemSkin
extends UseItem {
    public static final String SKIN_ID_TAG = "MMOITEMS_SKIN_ID";
    public static final String SKIN_TYPE_TAG = "MMOITEMS_SKIN_TYPE";

    @Deprecated
    public ItemSkin(Player player, NBTItem item) {
        super(player, item);
    }

    public ItemSkin(PlayerData player, NBTItem item) {
        super(player, item);
    }

    public ApplyResult applyOntoItem(NBTItem target, Type targetType) {
        List<String> acceptedMaterials;
        List<String> acceptedTypes;
        if (targetType == Type.SKIN) {
            return new ApplyResult(ResultType.NONE);
        }
        if (MMOItems.plugin.getConfig().getBoolean("locked-skins") && MMOUtils.isNonEmpty(target.getString(SKIN_ID_TAG))) {
            this.player.playSound(this.player.getLocation(), Sounds.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            Message.SKIN_REJECTED.format(ChatColor.RED, "#item#", MMOUtils.getDisplayName(target.getItem())).send(this.player);
            return new ApplyResult(ResultType.NONE);
        }
        if (this.mmoitem.hasData(ItemStats.COMPATIBLE_TYPES) && (acceptedTypes = ((StringListData)this.mmoitem.getData(ItemStats.COMPATIBLE_TYPES)).getList()).size() > 0 && acceptedTypes.stream().noneMatch(s -> s.equalsIgnoreCase(targetType.getId()))) {
            this.player.playSound(this.player.getLocation(), Sounds.ENTITY_PLAYER_LEVELUP, 1.0f, 2.0f);
            Message.SKIN_INCOMPATIBLE.format(ChatColor.RED, "#item#", MMOUtils.getDisplayName(target.getItem())).send(this.player);
            return new ApplyResult(ResultType.NONE);
        }
        if (this.mmoitem.hasData(ItemStats.COMPATIBLE_IDS)) {
            List<String> acceptedIDs = ((StringListData)this.mmoitem.getData(ItemStats.COMPATIBLE_IDS)).getList();
            String targetId = target.getString("MMOITEMS_ITEM_ID");
            if (acceptedIDs.size() > 0 && acceptedIDs.stream().noneMatch(s -> s.equalsIgnoreCase(targetId))) {
                this.player.playSound(this.player.getLocation(), Sounds.ENTITY_PLAYER_LEVELUP, 1.0f, 2.0f);
                Message.SKIN_INCOMPATIBLE.format(ChatColor.RED, "#item#", MMOUtils.getDisplayName(target.getItem())).send(this.player);
                return new ApplyResult(ResultType.NONE);
            }
        }
        if (this.mmoitem.hasData(ItemStats.COMPATIBLE_MATERIALS) && (acceptedMaterials = ((StringListData)this.mmoitem.getData(ItemStats.COMPATIBLE_MATERIALS)).getList()).size() > 0 && acceptedMaterials.stream().noneMatch(s -> s.equalsIgnoreCase(target.getItem().getType().name()))) {
            this.player.playSound(this.player.getLocation(), Sounds.ENTITY_PLAYER_LEVELUP, 1.0f, 2.0f);
            Message.SKIN_INCOMPATIBLE.format(ChatColor.RED, "#item#", MMOUtils.getDisplayName(target.getItem())).send(this.player);
            return new ApplyResult(ResultType.NONE);
        }
        double successRate = this.getNBTItem().getStat(ItemStats.SUCCESS_RATE.getId());
        if (successRate != 0.0 && RANDOM.nextDouble() < 1.0 - successRate / 100.0) {
            this.player.playSound(this.player.getLocation(), Sounds.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            Message.SKIN_BROKE.format(ChatColor.RED, "#item#", MMOUtils.getDisplayName(target.getItem())).send(this.player);
            return new ApplyResult(ResultType.FAILURE);
        }
        ItemStack item = ItemSkin.applySkin(target, this.mmoitem);
        this.player.playSound(this.player.getLocation(), Sounds.ENTITY_PLAYER_LEVELUP, 1.0f, 2.0f);
        Message.SKIN_APPLIED.format(ChatColor.YELLOW, "#item#", MMOUtils.getDisplayName(target.getItem())).send(this.player);
        return new ApplyResult(item);
    }

    @Deprecated
    @NotNull
    public static ItemStack applySkin(@NotNull NBTItem target, @NotNull VolatileMMOItem volSkin) {
        ItemStack item;
        NBTItem nbtSkin = volSkin.getNBT();
        String appliedSkinId = MMOUtils.requireNonEmptyElse(volSkin.getNBT().getString(SKIN_ID_TAG), nbtSkin.getString("MMOITEMS_ITEM_ID"));
        String appliedTypeId = MMOUtils.requireNonEmptyElse(volSkin.getNBT().getString(SKIN_TYPE_TAG), nbtSkin.getString("MMOITEMS_ITEM_TYPE"));
        target.addTag(new ItemTag[]{new ItemTag(SKIN_ID_TAG, (Object)appliedSkinId)});
        target.addTag(new ItemTag[]{new ItemTag(SKIN_TYPE_TAG, (Object)appliedTypeId)});
        if (!nbtSkin.getString("MMOITEMS_ITEM_PARTICLES").isEmpty()) {
            target.addTag(new ItemTag[]{new ItemTag("MMOITEMS_ITEM_PARTICLES", (Object)nbtSkin.getString("MMOITEMS_ITEM_PARTICLES"))});
        }
        if ((item = target.toItem()).getType() != nbtSkin.getItem().getType()) {
            item.setType(nbtSkin.getItem().getType());
        }
        ItemMeta meta = item.getItemMeta();
        ItemMeta skinMeta = nbtSkin.getItem().getItemMeta();
        if (skinMeta != null && meta != null) {
            if (skinMeta.hasCustomModelData()) {
                meta.setCustomModelData(Integer.valueOf(skinMeta.getCustomModelData()));
            }
            if (skinMeta.isUnbreakable()) {
                meta.setUnbreakable(true);
                if (meta instanceof Damageable && skinMeta instanceof Damageable) {
                    ((Damageable)meta).setDamage(((Damageable)skinMeta).getDamage());
                }
            }
            if (skinMeta instanceof LeatherArmorMeta && meta instanceof LeatherArmorMeta) {
                ((LeatherArmorMeta)meta).setColor(((LeatherArmorMeta)skinMeta).getColor());
            }
            if (skinMeta instanceof ArmorMeta && meta instanceof ArmorMeta) {
                ((ArmorMeta)meta).setTrim(((ArmorMeta)skinMeta).getTrim());
                if (skinMeta.hasItemFlag(ItemFlag.HIDE_ARMOR_TRIM)) {
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ARMOR_TRIM});
                } else {
                    meta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ARMOR_TRIM});
                }
            }
            if (volSkin.hasData(ItemStats.SKULL_TEXTURE) && item.getType() == Material.PLAYER_HEAD && nbtSkin.getItem().getType() == Material.PLAYER_HEAD) {
                MythicLib.plugin.getVersion().getWrapper().setProfile((SkullMeta)meta, ((SkullTextureData)volSkin.getData(ItemStats.SKULL_TEXTURE)).getGameProfile());
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static class ApplyResult {
        private final ResultType type;
        private final ItemStack result;

        public ApplyResult(ResultType type) {
            this(null, type);
        }

        public ApplyResult(ItemStack result) {
            this(result, ResultType.SUCCESS);
        }

        public ApplyResult(ItemStack result, ResultType type) {
            this.type = type;
            this.result = result;
        }

        public ResultType getType() {
            return this.type;
        }

        public ItemStack getResult() {
            return this.result;
        }
    }

    public static enum ResultType {
        FAILURE,
        NONE,
        SUCCESS;

    }
}

