/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.interaction;

import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.version.Sounds;
import java.util.UUID;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.event.item.ApplyGemStoneEvent;
import net.Indyuce.mmoitems.api.interaction.UseItem;
import net.Indyuce.mmoitems.api.item.mmoitem.LiveMMOItem;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.stat.Enchants;
import net.Indyuce.mmoitems.stat.GemUpgradeScaling;
import net.Indyuce.mmoitems.stat.data.GemSocketsData;
import net.Indyuce.mmoitems.stat.data.GemstoneData;
import net.Indyuce.mmoitems.stat.data.type.Mergeable;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.GemStoneStat;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.stat.type.StatHistory;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GemStone
extends UseItem {
    @Deprecated
    public GemStone(Player player, NBTItem item) {
        super(player, item);
    }

    public GemStone(PlayerData player, NBTItem item) {
        super(player, item);
    }

    @NotNull
    public ApplyResult applyOntoItem(@NotNull NBTItem target, @NotNull Type targetType) {
        return this.applyOntoItem(new LiveMMOItem(target), targetType, MMOUtils.getDisplayName(target.getItem()), true, false);
    }

    @NotNull
    public ApplyResult applyOntoItem(@NotNull MMOItem targetMMO, @NotNull Type targetType, @NotNull String itemName, boolean buildStack, boolean silent) {
        if (!targetMMO.hasData(ItemStats.GEM_SOCKETS)) {
            return new ApplyResult(ResultType.NONE);
        }
        String gemType = this.getNBTItem().getString(ItemStats.GEM_COLOR.getNBTPath());
        GemSocketsData sockets = (GemSocketsData)targetMMO.getData(ItemStats.GEM_SOCKETS);
        String foundSocketColor = sockets.getEmptySocket(gemType);
        if (foundSocketColor == null) {
            return new ApplyResult(ResultType.NONE);
        }
        String appliableTypes = this.getNBTItem().getString(ItemStats.ITEM_TYPE_RESTRICTION.getNBTPath());
        if (!(appliableTypes.isEmpty() || targetType.isWeapon() && appliableTypes.contains("WEAPON") || appliableTypes.contains(targetType.getId()))) {
            return new ApplyResult(ResultType.NONE);
        }
        double successRate = this.getNBTItem().getStat(ItemStats.SUCCESS_RATE.getId());
        if (successRate == 0.0) {
            successRate = 100.0;
        }
        ApplyGemStoneEvent called = new ApplyGemStoneEvent(this.playerData, this.mmoitem, targetMMO, RANDOM.nextDouble() > successRate / 100.0 ? ResultType.FAILURE : ResultType.SUCCESS);
        Bukkit.getPluginManager().callEvent((Event)called);
        if (called.isCancelled() || called.getResult() == ResultType.NONE) {
            return new ApplyResult(ResultType.NONE);
        }
        if (called.getResult() == ResultType.FAILURE) {
            if (!silent) {
                this.player.playSound(this.player.getLocation(), Sounds.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
                Message.GEM_STONE_BROKE.format(ChatColor.RED, "#gem#", MMOUtils.getDisplayName(this.getItem()), "#item#", itemName).send(this.player);
            }
            return new ApplyResult(ResultType.FAILURE);
        }
        Enchants.separateEnchantments(targetMMO);
        LiveMMOItem gemMMOItem = new LiveMMOItem(this.getNBTItem());
        GemstoneData gemData = new GemstoneData(gemMMOItem, foundSocketColor);
        StatHistory gemStory = targetMMO.computeStatHistory(ItemStats.GEM_SOCKETS);
        this.findEmptySocket(gemStory, gemType, gemData);
        targetMMO.setData(ItemStats.GEM_SOCKETS, gemStory.recalculate(targetMMO.getUpgradeLevel()));
        Integer levelIdentified = null;
        String scaling = gemMMOItem.hasData(ItemStats.GEM_UPGRADE_SCALING) ? gemMMOItem.getData(ItemStats.GEM_UPGRADE_SCALING).toString() : GemUpgradeScaling.defaultValue;
        switch (scaling) {
            case "HISTORIC": {
                levelIdentified = 0;
                break;
            }
            case "SUBSEQUENT": {
                levelIdentified = targetMMO.getUpgradeLevel();
                break;
            }
        }
        gemData.setLevel(levelIdentified);
        for (ItemStat stat : gemMMOItem.getStats()) {
            StatData data;
            if (stat instanceof GemStoneStat || !((data = gemMMOItem.getData(stat)) instanceof Mergeable)) continue;
            targetMMO.mergeData(stat, data, gemData.getHistoricUUID());
        }
        if (!silent) {
            this.player.playSound(this.player.getLocation(), Sounds.ENTITY_PLAYER_LEVELUP, 1.0f, 2.0f);
            Message.GEM_STONE_APPLIED.format(ChatColor.YELLOW, "#gem#", MMOUtils.getDisplayName(this.getItem()), "#item#", itemName).send(this.player);
        }
        if (buildStack) {
            return new ApplyResult(targetMMO.newBuilder().build());
        }
        return new ApplyResult(targetMMO, ResultType.SUCCESS);
    }

    private void findEmptySocket(StatHistory socketHistory, String gemType, GemstoneData gemstone) {
        GemSocketsData data = (GemSocketsData)socketHistory.getOriginalData();
        if (data.apply(gemType, gemstone)) {
            return;
        }
        for (UUID modifierId : socketHistory.getAllModifiers()) {
            data = (GemSocketsData)socketHistory.getModifiersBonus(modifierId);
            if (!data.apply(gemType, gemstone)) continue;
            return;
        }
        for (StatData untypedData : socketHistory.getExternalData()) {
            data = (GemSocketsData)untypedData;
            if (!data.apply(gemType, gemstone)) continue;
            return;
        }
        for (UUID gemId : socketHistory.getAllGemstones()) {
            data = (GemSocketsData)socketHistory.getGemstoneData(gemId);
            if (!data.apply(gemType, gemstone)) continue;
            return;
        }
        throw new RuntimeException("MMOItem contains available socket but not its socket stat history");
    }

    public static class ApplyResult {
        @NotNull
        private final ResultType type;
        @Nullable
        private final ItemStack result;
        @Nullable
        private final MMOItem resultAsMMOItem;

        public ApplyResult(@NotNull ResultType type) {
            this((ItemStack)null, type);
        }

        public ApplyResult(@Nullable ItemStack result) {
            this(result, ResultType.SUCCESS);
        }

        public ApplyResult(@Nullable ItemStack result, @NotNull ResultType type) {
            this.type = type;
            this.result = result;
            this.resultAsMMOItem = null;
        }

        public ApplyResult(@Nullable MMOItem result, @NotNull ResultType type) {
            this.type = type;
            this.result = null;
            this.resultAsMMOItem = result;
        }

        @NotNull
        public ResultType getType() {
            return this.type;
        }

        @Nullable
        public ItemStack getResult() {
            return this.result;
        }

        @Nullable
        public MMOItem getResultAsMMOItem() {
            return this.resultAsMMOItem;
        }
    }

    public static enum ResultType {
        FAILURE,
        NONE,
        SUCCESS;

    }
}

