/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.event;

import javax.annotation.Nullable;
import net.Indyuce.mmoitems.api.crafting.CraftingStation;
import net.Indyuce.mmoitems.api.crafting.recipe.CheckedRecipe;
import net.Indyuce.mmoitems.api.crafting.recipe.CraftingRecipe;
import net.Indyuce.mmoitems.api.crafting.recipe.Recipe;
import net.Indyuce.mmoitems.api.crafting.recipe.UpgradingRecipe;
import net.Indyuce.mmoitems.api.event.PlayerDataEvent;
import net.Indyuce.mmoitems.api.player.PlayerData;
import org.apache.commons.lang.Validate;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;

public class PlayerUseCraftingStationEvent
extends PlayerDataEvent {
    private final CraftingStation station;
    private final Recipe recipe;
    private final StationAction action;
    @Nullable
    private final CheckedRecipe recipeInfo;
    @Nullable
    private final ItemStack result;
    private static final HandlerList handlers = new HandlerList();

    public PlayerUseCraftingStationEvent(PlayerData playerData, CraftingStation station, CheckedRecipe recipeInfo) {
        this(playerData, station, recipeInfo, recipeInfo.getRecipe(), null, StationAction.INTERACT_WITH_RECIPE);
    }

    public PlayerUseCraftingStationEvent(PlayerData playerData, CraftingStation station, UpgradingRecipe.CheckedUpgradingRecipe recipeInfo) {
        this(playerData, station, recipeInfo, recipeInfo.getRecipe(), null, StationAction.UPGRADE_RECIPE);
    }

    public PlayerUseCraftingStationEvent(PlayerData playerData, CraftingStation station, CheckedRecipe recipeInfo, ItemStack result) {
        this(playerData, station, recipeInfo, recipeInfo.getRecipe(), result, StationAction.INSTANT_RECIPE);
    }

    public PlayerUseCraftingStationEvent(PlayerData playerData, CraftingStation station, Recipe recipe, ItemStack result) {
        this(playerData, station, null, recipe, result, StationAction.CRAFTING_QUEUE);
    }

    public PlayerUseCraftingStationEvent(PlayerData playerData, CraftingStation station, Recipe recipe) {
        this(playerData, station, null, recipe, null, StationAction.CANCEL_QUEUE);
    }

    private PlayerUseCraftingStationEvent(PlayerData playerData, CraftingStation station, CheckedRecipe recipeInfo, Recipe recipe, ItemStack result, StationAction action) {
        super(playerData);
        this.station = station;
        this.recipe = recipe;
        this.recipeInfo = recipeInfo;
        this.result = result;
        this.action = action;
    }

    public CraftingStation getStation() {
        return this.station;
    }

    public boolean hasRecipeInfo() {
        return this.recipeInfo != null;
    }

    public CheckedRecipe getRecipeInfo() {
        Validate.notNull((Object)(this.action == StationAction.INSTANT_RECIPE || this.action == StationAction.INTERACT_WITH_RECIPE ? 1 : 0), (String)("No recipe info is provided with " + this.action.name()));
        return this.recipeInfo;
    }

    public boolean hasResult() {
        return this.result != null;
    }

    public ItemStack getResult() {
        Validate.notNull((Object)(this.action == StationAction.INSTANT_RECIPE || this.action == StationAction.CRAFTING_QUEUE ? 1 : 0), (String)("No result item is provided with " + this.action.name()));
        return this.result;
    }

    public Recipe getRecipe() {
        return this.recipe;
    }

    public StationAction getInteraction() {
        return this.action;
    }

    @Deprecated
    public boolean isInstant() {
        return this.recipe instanceof CraftingRecipe && ((CraftingRecipe)this.recipe).isInstant();
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public static enum StationAction {
        UPGRADE_RECIPE,
        INTERACT_WITH_RECIPE,
        INSTANT_RECIPE,
        CRAFTING_QUEUE,
        CANCEL_QUEUE;

    }
}

