/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.event;

import java.util.List;
import net.Indyuce.mmoitems.api.block.CustomBlock;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;

public class ItemDropEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private boolean cancelled;
    private final DropCause cause;
    private final List<ItemStack> drops;
    private final LivingEntity player;
    private final Block block;
    private final Entity entity;
    private final String mythicMobName;
    private final CustomBlock customBlock;

    public ItemDropEvent(LivingEntity player, List<ItemStack> drops, CustomBlock customBlock) {
        this(player, drops, DropCause.CUSTOM_BLOCK, null, null, null, customBlock);
    }

    public ItemDropEvent(LivingEntity player, List<ItemStack> drops, Block block) {
        this(player, drops, DropCause.NORMAL_BLOCK, block, null, null, null);
    }

    public ItemDropEvent(LivingEntity player, List<ItemStack> drops, Entity entity) {
        this(player, drops, DropCause.NORMAL_MONSTER, null, entity, null, null);
    }

    @Deprecated
    public ItemDropEvent(LivingEntity player, List<ItemStack> drops, DropCause cause, String mythicMobName) {
        this(player, drops, DropCause.MYTHIC_MOB, null, null, mythicMobName, null);
    }

    private ItemDropEvent(LivingEntity player, List<ItemStack> drops, DropCause cause, Block block, Entity entity, String mythicMobName, CustomBlock customBlock) {
        this.player = player;
        this.cause = cause;
        this.drops = drops;
        this.block = block;
        this.entity = entity;
        this.mythicMobName = mythicMobName;
        this.customBlock = customBlock;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public List<ItemStack> getDrops() {
        return this.drops;
    }

    public DropCause getCause() {
        return this.cause;
    }

    public LivingEntity getWhoDropped() {
        return this.player;
    }

    public Block getMinedBlock() {
        return this.block;
    }

    public Entity getKilledEntity() {
        return this.entity;
    }

    public String getKilledMythicMobName() {
        return this.mythicMobName;
    }

    public void setCancelled(boolean bool) {
        this.cancelled = bool;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public static enum DropCause {
        NORMAL_BLOCK,
        NORMAL_MONSTER,
        MYTHIC_MOB,
        CUSTOM_BLOCK;

    }
}

